/*
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin
*/

var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// main.ts
var main_exports = {};
__export(main_exports, {
  default: () => OpenTimeExportPlugin
});
module.exports = __toCommonJS(main_exports);
var import_obsidian6 = require("obsidian");

// src/modals/CreateItemModal.ts
var import_obsidian2 = require("obsidian");

// src/types/opentime.ts
function generateId(prefix, title) {
  const sanitized = title.toLowerCase().replace(/[^a-z0-9]+/g, "-").replace(/^-|-$/g, "").substring(0, 40);
  return `${prefix}_${sanitized}_${Date.now().toString(36)}`;
}
function formatDate(date) {
  return date.toISOString().split("T")[0];
}

// src/ElysiumExporter.ts
var import_obsidian = require("obsidian");

// src/OpenTimeExporter.ts
var OpenTimeExporter = class {
  constructor(pluginVersion = "1.0.0") {
    this.pluginVersion = pluginVersion;
  }
  /**
   * Export document to YAML string
   */
  export(document) {
    const lines = [];
    lines.push(`# opentime export`);
    lines.push(`# generated by obsidian opentime export plugin`);
    lines.push("");
    lines.push(`opentime_version: "${document.opentime_version}"`);
    if (document.default_timezone) {
      lines.push(`default_timezone: "${document.default_timezone}"`);
    }
    lines.push(`generated_by: "Obsidian OpenTime Export ${this.pluginVersion}"`);
    lines.push(`created_at: "${new Date().toISOString()}"`);
    lines.push("");
    lines.push("items:");
    for (const item of document.items) {
      lines.push(...this.serializeItem(item));
    }
    return lines.join("\n");
  }
  /**
   * Serialize a single item to YAML lines
   */
  serializeItem(item) {
    const lines = [];
    const indent = "    ";
    lines.push(`  - type: ${item.type}`);
    lines.push(`${indent}id: ${this.quote(item.id)}`);
    lines.push(`${indent}title: ${this.quote(item.title)}`);
    switch (item.type) {
      case "goal":
        lines.push(`${indent}kind: goal`);
        if (item.target_date)
          lines.push(`${indent}target_date: ${this.quote(item.target_date)}`);
        if (item.progress !== void 0)
          lines.push(`${indent}progress: ${item.progress}`);
        if (item.estimate_minutes)
          lines.push(`${indent}estimate_minutes: ${item.estimate_minutes}`);
        if (item.project_id)
          lines.push(`${indent}project_id: ${this.quote(item.project_id)}`);
        if (item.repeats) {
          lines.push(...this.serializeRepeats(item.repeats, indent));
        }
        break;
      case "task":
        lines.push(`${indent}status: ${item.status}`);
        if (item.due)
          lines.push(`${indent}due: ${this.quote(item.due)}`);
        if (item.scheduled_start)
          lines.push(`${indent}scheduled_start: ${this.quote(item.scheduled_start)}`);
        if (item.estimate_minutes)
          lines.push(`${indent}estimate_minutes: ${item.estimate_minutes}`);
        if (item.actual_minutes)
          lines.push(`${indent}actual_minutes: ${item.actual_minutes}`);
        if (item.priority !== void 0)
          lines.push(`${indent}priority: ${item.priority}`);
        if (item.goal_id)
          lines.push(`${indent}goal_id: ${this.quote(item.goal_id)}`);
        if (item.project_id)
          lines.push(`${indent}project_id: ${this.quote(item.project_id)}`);
        if (item.repeats) {
          lines.push(...this.serializeRepeats(item.repeats, indent));
        }
        break;
      case "habit":
        if (item.pattern) {
          lines.push(`${indent}pattern:`);
          if (item.pattern.freq)
            lines.push(`${indent}  freq: ${item.pattern.freq}`);
          if (item.pattern.days_of_week) {
            lines.push(`${indent}  days_of_week: [${item.pattern.days_of_week.join(", ")}]`);
          }
        }
        if (item.window) {
          lines.push(`${indent}window:`);
          if (item.window.start_time)
            lines.push(`${indent}  start_time: ${this.quote(item.window.start_time)}`);
          if (item.window.end_time)
            lines.push(`${indent}  end_time: ${this.quote(item.window.end_time)}`);
        }
        if (item.streak) {
          lines.push(`${indent}streak:`);
          if (item.streak.current !== void 0)
            lines.push(`${indent}  current: ${item.streak.current}`);
          if (item.streak.longest !== void 0)
            lines.push(`${indent}  longest: ${item.streak.longest}`);
        }
        if (item.estimate_minutes)
          lines.push(`${indent}estimate_minutes: ${item.estimate_minutes}`);
        if (item.goal_id)
          lines.push(`${indent}goal_id: ${this.quote(item.goal_id)}`);
        if (item.project_id)
          lines.push(`${indent}project_id: ${this.quote(item.project_id)}`);
        if (item.repeats) {
          lines.push(...this.serializeRepeats(item.repeats, indent));
        }
        break;
      case "reminder":
        lines.push(`${indent}time: ${this.quote(item.time)}`);
        if (item.repeat)
          lines.push(`${indent}repeat: ${this.quote(item.repeat)}`);
        if (item.link)
          lines.push(`${indent}link: ${this.quote(item.link)}`);
        break;
      case "event":
        lines.push(`${indent}start: ${this.quote(item.start)}`);
        lines.push(`${indent}end: ${this.quote(item.end)}`);
        if (item.all_day !== void 0)
          lines.push(`${indent}all_day: ${item.all_day}`);
        if (item.timezone)
          lines.push(`${indent}timezone: ${this.quote(item.timezone)}`);
        if (item.location)
          lines.push(`${indent}location: ${this.quote(item.location)}`);
        if (item.recurrence)
          lines.push(`${indent}recurrence: ${this.quote(item.recurrence)}`);
        if (item.goal_id)
          lines.push(`${indent}goal_id: ${this.quote(item.goal_id)}`);
        if (item.project_id)
          lines.push(`${indent}project_id: ${this.quote(item.project_id)}`);
        break;
      case "appointment":
        lines.push(`${indent}start: ${this.quote(item.start)}`);
        lines.push(`${indent}end: ${this.quote(item.end)}`);
        lines.push(`${indent}attendees: [${item.attendees.map((a) => this.quote(a)).join(", ")}]`);
        if (item.location)
          lines.push(`${indent}location: ${this.quote(item.location)}`);
        if (item.provider)
          lines.push(`${indent}provider: ${this.quote(item.provider)}`);
        if (item.goal_id)
          lines.push(`${indent}goal_id: ${this.quote(item.goal_id)}`);
        if (item.project_id)
          lines.push(`${indent}project_id: ${this.quote(item.project_id)}`);
        break;
      case "project":
        lines.push(`${indent}kind: project`);
        if (item.children && item.children.length > 0) {
          lines.push(`${indent}children:`);
          for (const child of item.children) {
            lines.push(`${indent}  - ${child}`);
          }
        }
        if (item.progress !== void 0)
          lines.push(`${indent}progress: ${item.progress}`);
        if (item.target_date)
          lines.push(`${indent}target_date: ${this.quote(item.target_date)}`);
        if (item.estimate_minutes)
          lines.push(`${indent}estimate_minutes: ${item.estimate_minutes}`);
        break;
    }
    if (item.tags && item.tags.length > 0) {
      lines.push(`${indent}tags: [${item.tags.map((t) => this.quote(t)).join(", ")}]`);
    }
    if (item.categories && item.categories.length > 0) {
      lines.push(`${indent}categories: [${item.categories.map((c) => this.quote(c)).join(", ")}]`);
    }
    if (item.notes) {
      if (item.notes.includes("\n")) {
        lines.push(`${indent}notes: |`);
        for (const line of item.notes.split("\n")) {
          lines.push(`${indent}  ${line}`);
        }
      } else {
        lines.push(`${indent}notes: ${this.quote(item.notes)}`);
      }
    }
    if (item.steps && item.steps.length > 0) {
      lines.push(`${indent}steps:`);
      for (const step of item.steps) {
        lines.push(`${indent}  - id: ${this.quote(step.id)}`);
        lines.push(`${indent}    title: ${this.quote(step.title)}`);
        lines.push(`${indent}    completed: ${step.completed}`);
        lines.push(`${indent}    order: ${step.order}`);
        lines.push(`${indent}    status: ${step.status}`);
        if (step.due_date) {
          lines.push(`${indent}    due_date: ${this.quote(step.due_date)}`);
        }
      }
    }
    if (item.links && item.links.length > 0) {
      lines.push(`${indent}links:`);
      for (const link of item.links) {
        lines.push(`${indent}  - kind: ${link.kind}`);
        lines.push(`${indent}    value: ${this.quote(link.value)}`);
      }
    }
    if (item.x_obsidian) {
      lines.push(`${indent}x_obsidian:`);
      lines.push(`${indent}  source_file: ${this.quote(item.x_obsidian.source_file)}`);
      if (item.x_obsidian.folder_path) {
        lines.push(`${indent}  folder_path: ${this.quote(item.x_obsidian.folder_path)}`);
      }
      if (item.x_obsidian.line_number !== void 0) {
        lines.push(`${indent}  line_number: ${item.x_obsidian.line_number}`);
      }
      if (item.x_obsidian.original_text) {
        lines.push(`${indent}  original_text: ${this.quote(item.x_obsidian.original_text)}`);
      }
    }
    lines.push("");
    return lines;
  }
  /**
   * Serialize repeats/recurrence settings to YAML lines
   */
  serializeRepeats(repeats, indent) {
    const lines = [];
    lines.push(`${indent}repeats:`);
    lines.push(`${indent}  enabled: ${repeats.enabled}`);
    if (repeats.count !== void 0) {
      lines.push(`${indent}  count: ${repeats.count}`);
    }
    if (repeats.per) {
      lines.push(`${indent}  per: ${repeats.per}`);
    }
    if (repeats.weekdays && repeats.weekdays.length > 0) {
      lines.push(`${indent}  weekdays: [${repeats.weekdays.map((d) => this.quote(d)).join(", ")}]`);
    }
    if (repeats.end_type) {
      lines.push(`${indent}  end_type: ${repeats.end_type}`);
    }
    if (repeats.end_count !== void 0) {
      lines.push(`${indent}  end_count: ${repeats.end_count}`);
    }
    if (repeats.end_date) {
      lines.push(`${indent}  end_date: ${this.quote(repeats.end_date)}`);
    }
    return lines;
  }
  /**
   * Quote a string for YAML, handling special characters
   */
  quote(value) {
    const needsQuotes = /[:#[\]{}|>&*?!,'"%@`]|^\s|\s$|^-\s|^$/;
    if (needsQuotes.test(value) || value.includes("\n")) {
      return `"${value.replace(/"/g, '\\"').replace(/\n/g, "\\n")}"`;
    }
    return value;
  }
};

// src/ElysiumPreferences.ts
var import_child_process = require("child_process");
var import_util = require("util");
var execAsync = (0, import_util.promisify)(import_child_process.exec);
var DEFAULT_ELYSIUM_PREFS = {
  exportMode: "single",
  singleFilename: "elysium-schedule"
};
async function readElysiumPreferences() {
  const prefs = { ...DEFAULT_ELYSIUM_PREFS };
  try {
    try {
      const { stdout: modeOut } = await execAsync(
        'defaults read gingabox.Elysium "opentime.exportMode" 2>/dev/null'
      );
      const modeValue = modeOut.trim();
      prefs.exportMode = modeValue === "Per Item" ? "per-item" : "single";
    } catch (e) {
    }
    try {
      const { stdout: filenameOut } = await execAsync(
        'defaults read gingabox.Elysium "opentime.filename" 2>/dev/null'
      );
      const filename = filenameOut.trim();
      if (filename) {
        prefs.singleFilename = filename;
      }
    } catch (e) {
    }
    try {
      const { stdout: pathOut } = await execAsync(
        'defaults read gingabox.Elysium "opentime.customPath" 2>/dev/null'
      );
      const folderPath = pathOut.trim();
      if (folderPath) {
        prefs.folderPath = folderPath;
      }
    } catch (e) {
    }
  } catch (e) {
    console.debug("[OpenTime] Elysium preferences not found, using defaults");
  }
  return prefs;
}
async function isElysiumInstalled() {
  try {
    await execAsync("defaults read gingabox.Elysium 2>/dev/null");
    return true;
  } catch (e) {
    return false;
  }
}
function getExportModeDescription(prefs) {
  if (prefs.exportMode === "per-item") {
    return "per item (elysium-{type}-{title}.ot)";
  }
  return `single file (${prefs.singleFilename}.ot)`;
}

// node_modules/js-yaml/dist/js-yaml.mjs
function isNothing(subject) {
  return typeof subject === "undefined" || subject === null;
}
function isObject(subject) {
  return typeof subject === "object" && subject !== null;
}
function toArray(sequence) {
  if (Array.isArray(sequence))
    return sequence;
  else if (isNothing(sequence))
    return [];
  return [sequence];
}
function extend(target, source) {
  var index, length, key, sourceKeys;
  if (source) {
    sourceKeys = Object.keys(source);
    for (index = 0, length = sourceKeys.length; index < length; index += 1) {
      key = sourceKeys[index];
      target[key] = source[key];
    }
  }
  return target;
}
function repeat(string, count) {
  var result = "", cycle;
  for (cycle = 0; cycle < count; cycle += 1) {
    result += string;
  }
  return result;
}
function isNegativeZero(number) {
  return number === 0 && Number.NEGATIVE_INFINITY === 1 / number;
}
var isNothing_1 = isNothing;
var isObject_1 = isObject;
var toArray_1 = toArray;
var repeat_1 = repeat;
var isNegativeZero_1 = isNegativeZero;
var extend_1 = extend;
var common = {
  isNothing: isNothing_1,
  isObject: isObject_1,
  toArray: toArray_1,
  repeat: repeat_1,
  isNegativeZero: isNegativeZero_1,
  extend: extend_1
};
function formatError(exception2, compact) {
  var where = "", message = exception2.reason || "(unknown reason)";
  if (!exception2.mark)
    return message;
  if (exception2.mark.name) {
    where += 'in "' + exception2.mark.name + '" ';
  }
  where += "(" + (exception2.mark.line + 1) + ":" + (exception2.mark.column + 1) + ")";
  if (!compact && exception2.mark.snippet) {
    where += "\n\n" + exception2.mark.snippet;
  }
  return message + " " + where;
}
function YAMLException$1(reason, mark) {
  Error.call(this);
  this.name = "YAMLException";
  this.reason = reason;
  this.mark = mark;
  this.message = formatError(this, false);
  if (Error.captureStackTrace) {
    Error.captureStackTrace(this, this.constructor);
  } else {
    this.stack = new Error().stack || "";
  }
}
YAMLException$1.prototype = Object.create(Error.prototype);
YAMLException$1.prototype.constructor = YAMLException$1;
YAMLException$1.prototype.toString = function toString(compact) {
  return this.name + ": " + formatError(this, compact);
};
var exception = YAMLException$1;
function getLine(buffer, lineStart, lineEnd, position, maxLineLength) {
  var head = "";
  var tail = "";
  var maxHalfLength = Math.floor(maxLineLength / 2) - 1;
  if (position - lineStart > maxHalfLength) {
    head = " ... ";
    lineStart = position - maxHalfLength + head.length;
  }
  if (lineEnd - position > maxHalfLength) {
    tail = " ...";
    lineEnd = position + maxHalfLength - tail.length;
  }
  return {
    str: head + buffer.slice(lineStart, lineEnd).replace(/\t/g, "\u2192") + tail,
    pos: position - lineStart + head.length
    // relative position
  };
}
function padStart(string, max) {
  return common.repeat(" ", max - string.length) + string;
}
function makeSnippet(mark, options) {
  options = Object.create(options || null);
  if (!mark.buffer)
    return null;
  if (!options.maxLength)
    options.maxLength = 79;
  if (typeof options.indent !== "number")
    options.indent = 1;
  if (typeof options.linesBefore !== "number")
    options.linesBefore = 3;
  if (typeof options.linesAfter !== "number")
    options.linesAfter = 2;
  var re = /\r?\n|\r|\0/g;
  var lineStarts = [0];
  var lineEnds = [];
  var match;
  var foundLineNo = -1;
  while (match = re.exec(mark.buffer)) {
    lineEnds.push(match.index);
    lineStarts.push(match.index + match[0].length);
    if (mark.position <= match.index && foundLineNo < 0) {
      foundLineNo = lineStarts.length - 2;
    }
  }
  if (foundLineNo < 0)
    foundLineNo = lineStarts.length - 1;
  var result = "", i, line;
  var lineNoLength = Math.min(mark.line + options.linesAfter, lineEnds.length).toString().length;
  var maxLineLength = options.maxLength - (options.indent + lineNoLength + 3);
  for (i = 1; i <= options.linesBefore; i++) {
    if (foundLineNo - i < 0)
      break;
    line = getLine(
      mark.buffer,
      lineStarts[foundLineNo - i],
      lineEnds[foundLineNo - i],
      mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo - i]),
      maxLineLength
    );
    result = common.repeat(" ", options.indent) + padStart((mark.line - i + 1).toString(), lineNoLength) + " | " + line.str + "\n" + result;
  }
  line = getLine(mark.buffer, lineStarts[foundLineNo], lineEnds[foundLineNo], mark.position, maxLineLength);
  result += common.repeat(" ", options.indent) + padStart((mark.line + 1).toString(), lineNoLength) + " | " + line.str + "\n";
  result += common.repeat("-", options.indent + lineNoLength + 3 + line.pos) + "^\n";
  for (i = 1; i <= options.linesAfter; i++) {
    if (foundLineNo + i >= lineEnds.length)
      break;
    line = getLine(
      mark.buffer,
      lineStarts[foundLineNo + i],
      lineEnds[foundLineNo + i],
      mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo + i]),
      maxLineLength
    );
    result += common.repeat(" ", options.indent) + padStart((mark.line + i + 1).toString(), lineNoLength) + " | " + line.str + "\n";
  }
  return result.replace(/\n$/, "");
}
var snippet = makeSnippet;
var TYPE_CONSTRUCTOR_OPTIONS = [
  "kind",
  "multi",
  "resolve",
  "construct",
  "instanceOf",
  "predicate",
  "represent",
  "representName",
  "defaultStyle",
  "styleAliases"
];
var YAML_NODE_KINDS = [
  "scalar",
  "sequence",
  "mapping"
];
function compileStyleAliases(map2) {
  var result = {};
  if (map2 !== null) {
    Object.keys(map2).forEach(function(style) {
      map2[style].forEach(function(alias) {
        result[String(alias)] = style;
      });
    });
  }
  return result;
}
function Type$1(tag, options) {
  options = options || {};
  Object.keys(options).forEach(function(name) {
    if (TYPE_CONSTRUCTOR_OPTIONS.indexOf(name) === -1) {
      throw new exception('Unknown option "' + name + '" is met in definition of "' + tag + '" YAML type.');
    }
  });
  this.options = options;
  this.tag = tag;
  this.kind = options["kind"] || null;
  this.resolve = options["resolve"] || function() {
    return true;
  };
  this.construct = options["construct"] || function(data) {
    return data;
  };
  this.instanceOf = options["instanceOf"] || null;
  this.predicate = options["predicate"] || null;
  this.represent = options["represent"] || null;
  this.representName = options["representName"] || null;
  this.defaultStyle = options["defaultStyle"] || null;
  this.multi = options["multi"] || false;
  this.styleAliases = compileStyleAliases(options["styleAliases"] || null);
  if (YAML_NODE_KINDS.indexOf(this.kind) === -1) {
    throw new exception('Unknown kind "' + this.kind + '" is specified for "' + tag + '" YAML type.');
  }
}
var type = Type$1;
function compileList(schema2, name) {
  var result = [];
  schema2[name].forEach(function(currentType) {
    var newIndex = result.length;
    result.forEach(function(previousType, previousIndex) {
      if (previousType.tag === currentType.tag && previousType.kind === currentType.kind && previousType.multi === currentType.multi) {
        newIndex = previousIndex;
      }
    });
    result[newIndex] = currentType;
  });
  return result;
}
function compileMap() {
  var result = {
    scalar: {},
    sequence: {},
    mapping: {},
    fallback: {},
    multi: {
      scalar: [],
      sequence: [],
      mapping: [],
      fallback: []
    }
  }, index, length;
  function collectType(type2) {
    if (type2.multi) {
      result.multi[type2.kind].push(type2);
      result.multi["fallback"].push(type2);
    } else {
      result[type2.kind][type2.tag] = result["fallback"][type2.tag] = type2;
    }
  }
  for (index = 0, length = arguments.length; index < length; index += 1) {
    arguments[index].forEach(collectType);
  }
  return result;
}
function Schema$1(definition) {
  return this.extend(definition);
}
Schema$1.prototype.extend = function extend2(definition) {
  var implicit = [];
  var explicit = [];
  if (definition instanceof type) {
    explicit.push(definition);
  } else if (Array.isArray(definition)) {
    explicit = explicit.concat(definition);
  } else if (definition && (Array.isArray(definition.implicit) || Array.isArray(definition.explicit))) {
    if (definition.implicit)
      implicit = implicit.concat(definition.implicit);
    if (definition.explicit)
      explicit = explicit.concat(definition.explicit);
  } else {
    throw new exception("Schema.extend argument should be a Type, [ Type ], or a schema definition ({ implicit: [...], explicit: [...] })");
  }
  implicit.forEach(function(type$1) {
    if (!(type$1 instanceof type)) {
      throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");
    }
    if (type$1.loadKind && type$1.loadKind !== "scalar") {
      throw new exception("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.");
    }
    if (type$1.multi) {
      throw new exception("There is a multi type in the implicit list of a schema. Multi tags can only be listed as explicit.");
    }
  });
  explicit.forEach(function(type$1) {
    if (!(type$1 instanceof type)) {
      throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");
    }
  });
  var result = Object.create(Schema$1.prototype);
  result.implicit = (this.implicit || []).concat(implicit);
  result.explicit = (this.explicit || []).concat(explicit);
  result.compiledImplicit = compileList(result, "implicit");
  result.compiledExplicit = compileList(result, "explicit");
  result.compiledTypeMap = compileMap(result.compiledImplicit, result.compiledExplicit);
  return result;
};
var schema = Schema$1;
var str = new type("tag:yaml.org,2002:str", {
  kind: "scalar",
  construct: function(data) {
    return data !== null ? data : "";
  }
});
var seq = new type("tag:yaml.org,2002:seq", {
  kind: "sequence",
  construct: function(data) {
    return data !== null ? data : [];
  }
});
var map = new type("tag:yaml.org,2002:map", {
  kind: "mapping",
  construct: function(data) {
    return data !== null ? data : {};
  }
});
var failsafe = new schema({
  explicit: [
    str,
    seq,
    map
  ]
});
function resolveYamlNull(data) {
  if (data === null)
    return true;
  var max = data.length;
  return max === 1 && data === "~" || max === 4 && (data === "null" || data === "Null" || data === "NULL");
}
function constructYamlNull() {
  return null;
}
function isNull(object) {
  return object === null;
}
var _null = new type("tag:yaml.org,2002:null", {
  kind: "scalar",
  resolve: resolveYamlNull,
  construct: constructYamlNull,
  predicate: isNull,
  represent: {
    canonical: function() {
      return "~";
    },
    lowercase: function() {
      return "null";
    },
    uppercase: function() {
      return "NULL";
    },
    camelcase: function() {
      return "Null";
    },
    empty: function() {
      return "";
    }
  },
  defaultStyle: "lowercase"
});
function resolveYamlBoolean(data) {
  if (data === null)
    return false;
  var max = data.length;
  return max === 4 && (data === "true" || data === "True" || data === "TRUE") || max === 5 && (data === "false" || data === "False" || data === "FALSE");
}
function constructYamlBoolean(data) {
  return data === "true" || data === "True" || data === "TRUE";
}
function isBoolean(object) {
  return Object.prototype.toString.call(object) === "[object Boolean]";
}
var bool = new type("tag:yaml.org,2002:bool", {
  kind: "scalar",
  resolve: resolveYamlBoolean,
  construct: constructYamlBoolean,
  predicate: isBoolean,
  represent: {
    lowercase: function(object) {
      return object ? "true" : "false";
    },
    uppercase: function(object) {
      return object ? "TRUE" : "FALSE";
    },
    camelcase: function(object) {
      return object ? "True" : "False";
    }
  },
  defaultStyle: "lowercase"
});
function isHexCode(c) {
  return 48 <= c && c <= 57 || 65 <= c && c <= 70 || 97 <= c && c <= 102;
}
function isOctCode(c) {
  return 48 <= c && c <= 55;
}
function isDecCode(c) {
  return 48 <= c && c <= 57;
}
function resolveYamlInteger(data) {
  if (data === null)
    return false;
  var max = data.length, index = 0, hasDigits = false, ch;
  if (!max)
    return false;
  ch = data[index];
  if (ch === "-" || ch === "+") {
    ch = data[++index];
  }
  if (ch === "0") {
    if (index + 1 === max)
      return true;
    ch = data[++index];
    if (ch === "b") {
      index++;
      for (; index < max; index++) {
        ch = data[index];
        if (ch === "_")
          continue;
        if (ch !== "0" && ch !== "1")
          return false;
        hasDigits = true;
      }
      return hasDigits && ch !== "_";
    }
    if (ch === "x") {
      index++;
      for (; index < max; index++) {
        ch = data[index];
        if (ch === "_")
          continue;
        if (!isHexCode(data.charCodeAt(index)))
          return false;
        hasDigits = true;
      }
      return hasDigits && ch !== "_";
    }
    if (ch === "o") {
      index++;
      for (; index < max; index++) {
        ch = data[index];
        if (ch === "_")
          continue;
        if (!isOctCode(data.charCodeAt(index)))
          return false;
        hasDigits = true;
      }
      return hasDigits && ch !== "_";
    }
  }
  if (ch === "_")
    return false;
  for (; index < max; index++) {
    ch = data[index];
    if (ch === "_")
      continue;
    if (!isDecCode(data.charCodeAt(index))) {
      return false;
    }
    hasDigits = true;
  }
  if (!hasDigits || ch === "_")
    return false;
  return true;
}
function constructYamlInteger(data) {
  var value = data, sign = 1, ch;
  if (value.indexOf("_") !== -1) {
    value = value.replace(/_/g, "");
  }
  ch = value[0];
  if (ch === "-" || ch === "+") {
    if (ch === "-")
      sign = -1;
    value = value.slice(1);
    ch = value[0];
  }
  if (value === "0")
    return 0;
  if (ch === "0") {
    if (value[1] === "b")
      return sign * parseInt(value.slice(2), 2);
    if (value[1] === "x")
      return sign * parseInt(value.slice(2), 16);
    if (value[1] === "o")
      return sign * parseInt(value.slice(2), 8);
  }
  return sign * parseInt(value, 10);
}
function isInteger(object) {
  return Object.prototype.toString.call(object) === "[object Number]" && (object % 1 === 0 && !common.isNegativeZero(object));
}
var int = new type("tag:yaml.org,2002:int", {
  kind: "scalar",
  resolve: resolveYamlInteger,
  construct: constructYamlInteger,
  predicate: isInteger,
  represent: {
    binary: function(obj) {
      return obj >= 0 ? "0b" + obj.toString(2) : "-0b" + obj.toString(2).slice(1);
    },
    octal: function(obj) {
      return obj >= 0 ? "0o" + obj.toString(8) : "-0o" + obj.toString(8).slice(1);
    },
    decimal: function(obj) {
      return obj.toString(10);
    },
    /* eslint-disable max-len */
    hexadecimal: function(obj) {
      return obj >= 0 ? "0x" + obj.toString(16).toUpperCase() : "-0x" + obj.toString(16).toUpperCase().slice(1);
    }
  },
  defaultStyle: "decimal",
  styleAliases: {
    binary: [2, "bin"],
    octal: [8, "oct"],
    decimal: [10, "dec"],
    hexadecimal: [16, "hex"]
  }
});
var YAML_FLOAT_PATTERN = new RegExp(
  // 2.5e4, 2.5 and integers
  "^(?:[-+]?(?:[0-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$"
);
function resolveYamlFloat(data) {
  if (data === null)
    return false;
  if (!YAML_FLOAT_PATTERN.test(data) || // Quick hack to not allow integers end with `_`
  // Probably should update regexp & check speed
  data[data.length - 1] === "_") {
    return false;
  }
  return true;
}
function constructYamlFloat(data) {
  var value, sign;
  value = data.replace(/_/g, "").toLowerCase();
  sign = value[0] === "-" ? -1 : 1;
  if ("+-".indexOf(value[0]) >= 0) {
    value = value.slice(1);
  }
  if (value === ".inf") {
    return sign === 1 ? Number.POSITIVE_INFINITY : Number.NEGATIVE_INFINITY;
  } else if (value === ".nan") {
    return NaN;
  }
  return sign * parseFloat(value, 10);
}
var SCIENTIFIC_WITHOUT_DOT = /^[-+]?[0-9]+e/;
function representYamlFloat(object, style) {
  var res;
  if (isNaN(object)) {
    switch (style) {
      case "lowercase":
        return ".nan";
      case "uppercase":
        return ".NAN";
      case "camelcase":
        return ".NaN";
    }
  } else if (Number.POSITIVE_INFINITY === object) {
    switch (style) {
      case "lowercase":
        return ".inf";
      case "uppercase":
        return ".INF";
      case "camelcase":
        return ".Inf";
    }
  } else if (Number.NEGATIVE_INFINITY === object) {
    switch (style) {
      case "lowercase":
        return "-.inf";
      case "uppercase":
        return "-.INF";
      case "camelcase":
        return "-.Inf";
    }
  } else if (common.isNegativeZero(object)) {
    return "-0.0";
  }
  res = object.toString(10);
  return SCIENTIFIC_WITHOUT_DOT.test(res) ? res.replace("e", ".e") : res;
}
function isFloat(object) {
  return Object.prototype.toString.call(object) === "[object Number]" && (object % 1 !== 0 || common.isNegativeZero(object));
}
var float = new type("tag:yaml.org,2002:float", {
  kind: "scalar",
  resolve: resolveYamlFloat,
  construct: constructYamlFloat,
  predicate: isFloat,
  represent: representYamlFloat,
  defaultStyle: "lowercase"
});
var json = failsafe.extend({
  implicit: [
    _null,
    bool,
    int,
    float
  ]
});
var core = json;
var YAML_DATE_REGEXP = new RegExp(
  "^([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9])$"
);
var YAML_TIMESTAMP_REGEXP = new RegExp(
  "^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:[Tt]|[ \\t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \\t]*(Z|([-+])([0-9][0-9]?)(?::([0-9][0-9]))?))?$"
);
function resolveYamlTimestamp(data) {
  if (data === null)
    return false;
  if (YAML_DATE_REGEXP.exec(data) !== null)
    return true;
  if (YAML_TIMESTAMP_REGEXP.exec(data) !== null)
    return true;
  return false;
}
function constructYamlTimestamp(data) {
  var match, year, month, day, hour, minute, second, fraction = 0, delta = null, tz_hour, tz_minute, date;
  match = YAML_DATE_REGEXP.exec(data);
  if (match === null)
    match = YAML_TIMESTAMP_REGEXP.exec(data);
  if (match === null)
    throw new Error("Date resolve error");
  year = +match[1];
  month = +match[2] - 1;
  day = +match[3];
  if (!match[4]) {
    return new Date(Date.UTC(year, month, day));
  }
  hour = +match[4];
  minute = +match[5];
  second = +match[6];
  if (match[7]) {
    fraction = match[7].slice(0, 3);
    while (fraction.length < 3) {
      fraction += "0";
    }
    fraction = +fraction;
  }
  if (match[9]) {
    tz_hour = +match[10];
    tz_minute = +(match[11] || 0);
    delta = (tz_hour * 60 + tz_minute) * 6e4;
    if (match[9] === "-")
      delta = -delta;
  }
  date = new Date(Date.UTC(year, month, day, hour, minute, second, fraction));
  if (delta)
    date.setTime(date.getTime() - delta);
  return date;
}
function representYamlTimestamp(object) {
  return object.toISOString();
}
var timestamp = new type("tag:yaml.org,2002:timestamp", {
  kind: "scalar",
  resolve: resolveYamlTimestamp,
  construct: constructYamlTimestamp,
  instanceOf: Date,
  represent: representYamlTimestamp
});
function resolveYamlMerge(data) {
  return data === "<<" || data === null;
}
var merge = new type("tag:yaml.org,2002:merge", {
  kind: "scalar",
  resolve: resolveYamlMerge
});
var BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";
function resolveYamlBinary(data) {
  if (data === null)
    return false;
  var code, idx, bitlen = 0, max = data.length, map2 = BASE64_MAP;
  for (idx = 0; idx < max; idx++) {
    code = map2.indexOf(data.charAt(idx));
    if (code > 64)
      continue;
    if (code < 0)
      return false;
    bitlen += 6;
  }
  return bitlen % 8 === 0;
}
function constructYamlBinary(data) {
  var idx, tailbits, input = data.replace(/[\r\n=]/g, ""), max = input.length, map2 = BASE64_MAP, bits = 0, result = [];
  for (idx = 0; idx < max; idx++) {
    if (idx % 4 === 0 && idx) {
      result.push(bits >> 16 & 255);
      result.push(bits >> 8 & 255);
      result.push(bits & 255);
    }
    bits = bits << 6 | map2.indexOf(input.charAt(idx));
  }
  tailbits = max % 4 * 6;
  if (tailbits === 0) {
    result.push(bits >> 16 & 255);
    result.push(bits >> 8 & 255);
    result.push(bits & 255);
  } else if (tailbits === 18) {
    result.push(bits >> 10 & 255);
    result.push(bits >> 2 & 255);
  } else if (tailbits === 12) {
    result.push(bits >> 4 & 255);
  }
  return new Uint8Array(result);
}
function representYamlBinary(object) {
  var result = "", bits = 0, idx, tail, max = object.length, map2 = BASE64_MAP;
  for (idx = 0; idx < max; idx++) {
    if (idx % 3 === 0 && idx) {
      result += map2[bits >> 18 & 63];
      result += map2[bits >> 12 & 63];
      result += map2[bits >> 6 & 63];
      result += map2[bits & 63];
    }
    bits = (bits << 8) + object[idx];
  }
  tail = max % 3;
  if (tail === 0) {
    result += map2[bits >> 18 & 63];
    result += map2[bits >> 12 & 63];
    result += map2[bits >> 6 & 63];
    result += map2[bits & 63];
  } else if (tail === 2) {
    result += map2[bits >> 10 & 63];
    result += map2[bits >> 4 & 63];
    result += map2[bits << 2 & 63];
    result += map2[64];
  } else if (tail === 1) {
    result += map2[bits >> 2 & 63];
    result += map2[bits << 4 & 63];
    result += map2[64];
    result += map2[64];
  }
  return result;
}
function isBinary(obj) {
  return Object.prototype.toString.call(obj) === "[object Uint8Array]";
}
var binary = new type("tag:yaml.org,2002:binary", {
  kind: "scalar",
  resolve: resolveYamlBinary,
  construct: constructYamlBinary,
  predicate: isBinary,
  represent: representYamlBinary
});
var _hasOwnProperty$3 = Object.prototype.hasOwnProperty;
var _toString$2 = Object.prototype.toString;
function resolveYamlOmap(data) {
  if (data === null)
    return true;
  var objectKeys = [], index, length, pair, pairKey, pairHasKey, object = data;
  for (index = 0, length = object.length; index < length; index += 1) {
    pair = object[index];
    pairHasKey = false;
    if (_toString$2.call(pair) !== "[object Object]")
      return false;
    for (pairKey in pair) {
      if (_hasOwnProperty$3.call(pair, pairKey)) {
        if (!pairHasKey)
          pairHasKey = true;
        else
          return false;
      }
    }
    if (!pairHasKey)
      return false;
    if (objectKeys.indexOf(pairKey) === -1)
      objectKeys.push(pairKey);
    else
      return false;
  }
  return true;
}
function constructYamlOmap(data) {
  return data !== null ? data : [];
}
var omap = new type("tag:yaml.org,2002:omap", {
  kind: "sequence",
  resolve: resolveYamlOmap,
  construct: constructYamlOmap
});
var _toString$1 = Object.prototype.toString;
function resolveYamlPairs(data) {
  if (data === null)
    return true;
  var index, length, pair, keys, result, object = data;
  result = new Array(object.length);
  for (index = 0, length = object.length; index < length; index += 1) {
    pair = object[index];
    if (_toString$1.call(pair) !== "[object Object]")
      return false;
    keys = Object.keys(pair);
    if (keys.length !== 1)
      return false;
    result[index] = [keys[0], pair[keys[0]]];
  }
  return true;
}
function constructYamlPairs(data) {
  if (data === null)
    return [];
  var index, length, pair, keys, result, object = data;
  result = new Array(object.length);
  for (index = 0, length = object.length; index < length; index += 1) {
    pair = object[index];
    keys = Object.keys(pair);
    result[index] = [keys[0], pair[keys[0]]];
  }
  return result;
}
var pairs = new type("tag:yaml.org,2002:pairs", {
  kind: "sequence",
  resolve: resolveYamlPairs,
  construct: constructYamlPairs
});
var _hasOwnProperty$2 = Object.prototype.hasOwnProperty;
function resolveYamlSet(data) {
  if (data === null)
    return true;
  var key, object = data;
  for (key in object) {
    if (_hasOwnProperty$2.call(object, key)) {
      if (object[key] !== null)
        return false;
    }
  }
  return true;
}
function constructYamlSet(data) {
  return data !== null ? data : {};
}
var set = new type("tag:yaml.org,2002:set", {
  kind: "mapping",
  resolve: resolveYamlSet,
  construct: constructYamlSet
});
var _default = core.extend({
  implicit: [
    timestamp,
    merge
  ],
  explicit: [
    binary,
    omap,
    pairs,
    set
  ]
});
var _hasOwnProperty$1 = Object.prototype.hasOwnProperty;
var CONTEXT_FLOW_IN = 1;
var CONTEXT_FLOW_OUT = 2;
var CONTEXT_BLOCK_IN = 3;
var CONTEXT_BLOCK_OUT = 4;
var CHOMPING_CLIP = 1;
var CHOMPING_STRIP = 2;
var CHOMPING_KEEP = 3;
var PATTERN_NON_PRINTABLE = /[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
var PATTERN_NON_ASCII_LINE_BREAKS = /[\x85\u2028\u2029]/;
var PATTERN_FLOW_INDICATORS = /[,\[\]\{\}]/;
var PATTERN_TAG_HANDLE = /^(?:!|!!|![a-z\-]+!)$/i;
var PATTERN_TAG_URI = /^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;
function _class(obj) {
  return Object.prototype.toString.call(obj);
}
function is_EOL(c) {
  return c === 10 || c === 13;
}
function is_WHITE_SPACE(c) {
  return c === 9 || c === 32;
}
function is_WS_OR_EOL(c) {
  return c === 9 || c === 32 || c === 10 || c === 13;
}
function is_FLOW_INDICATOR(c) {
  return c === 44 || c === 91 || c === 93 || c === 123 || c === 125;
}
function fromHexCode(c) {
  var lc;
  if (48 <= c && c <= 57) {
    return c - 48;
  }
  lc = c | 32;
  if (97 <= lc && lc <= 102) {
    return lc - 97 + 10;
  }
  return -1;
}
function escapedHexLen(c) {
  if (c === 120) {
    return 2;
  }
  if (c === 117) {
    return 4;
  }
  if (c === 85) {
    return 8;
  }
  return 0;
}
function fromDecimalCode(c) {
  if (48 <= c && c <= 57) {
    return c - 48;
  }
  return -1;
}
function simpleEscapeSequence(c) {
  return c === 48 ? "\0" : c === 97 ? "\x07" : c === 98 ? "\b" : c === 116 ? "	" : c === 9 ? "	" : c === 110 ? "\n" : c === 118 ? "\v" : c === 102 ? "\f" : c === 114 ? "\r" : c === 101 ? "\x1B" : c === 32 ? " " : c === 34 ? '"' : c === 47 ? "/" : c === 92 ? "\\" : c === 78 ? "\x85" : c === 95 ? "\xA0" : c === 76 ? "\u2028" : c === 80 ? "\u2029" : "";
}
function charFromCodepoint(c) {
  if (c <= 65535) {
    return String.fromCharCode(c);
  }
  return String.fromCharCode(
    (c - 65536 >> 10) + 55296,
    (c - 65536 & 1023) + 56320
  );
}
function setProperty(object, key, value) {
  if (key === "__proto__") {
    Object.defineProperty(object, key, {
      configurable: true,
      enumerable: true,
      writable: true,
      value
    });
  } else {
    object[key] = value;
  }
}
var simpleEscapeCheck = new Array(256);
var simpleEscapeMap = new Array(256);
for (i = 0; i < 256; i++) {
  simpleEscapeCheck[i] = simpleEscapeSequence(i) ? 1 : 0;
  simpleEscapeMap[i] = simpleEscapeSequence(i);
}
var i;
function State$1(input, options) {
  this.input = input;
  this.filename = options["filename"] || null;
  this.schema = options["schema"] || _default;
  this.onWarning = options["onWarning"] || null;
  this.legacy = options["legacy"] || false;
  this.json = options["json"] || false;
  this.listener = options["listener"] || null;
  this.implicitTypes = this.schema.compiledImplicit;
  this.typeMap = this.schema.compiledTypeMap;
  this.length = input.length;
  this.position = 0;
  this.line = 0;
  this.lineStart = 0;
  this.lineIndent = 0;
  this.firstTabInLine = -1;
  this.documents = [];
}
function generateError(state, message) {
  var mark = {
    name: state.filename,
    buffer: state.input.slice(0, -1),
    // omit trailing \0
    position: state.position,
    line: state.line,
    column: state.position - state.lineStart
  };
  mark.snippet = snippet(mark);
  return new exception(message, mark);
}
function throwError(state, message) {
  throw generateError(state, message);
}
function throwWarning(state, message) {
  if (state.onWarning) {
    state.onWarning.call(null, generateError(state, message));
  }
}
var directiveHandlers = {
  YAML: function handleYamlDirective(state, name, args) {
    var match, major, minor;
    if (state.version !== null) {
      throwError(state, "duplication of %YAML directive");
    }
    if (args.length !== 1) {
      throwError(state, "YAML directive accepts exactly one argument");
    }
    match = /^([0-9]+)\.([0-9]+)$/.exec(args[0]);
    if (match === null) {
      throwError(state, "ill-formed argument of the YAML directive");
    }
    major = parseInt(match[1], 10);
    minor = parseInt(match[2], 10);
    if (major !== 1) {
      throwError(state, "unacceptable YAML version of the document");
    }
    state.version = args[0];
    state.checkLineBreaks = minor < 2;
    if (minor !== 1 && minor !== 2) {
      throwWarning(state, "unsupported YAML version of the document");
    }
  },
  TAG: function handleTagDirective(state, name, args) {
    var handle, prefix;
    if (args.length !== 2) {
      throwError(state, "TAG directive accepts exactly two arguments");
    }
    handle = args[0];
    prefix = args[1];
    if (!PATTERN_TAG_HANDLE.test(handle)) {
      throwError(state, "ill-formed tag handle (first argument) of the TAG directive");
    }
    if (_hasOwnProperty$1.call(state.tagMap, handle)) {
      throwError(state, 'there is a previously declared suffix for "' + handle + '" tag handle');
    }
    if (!PATTERN_TAG_URI.test(prefix)) {
      throwError(state, "ill-formed tag prefix (second argument) of the TAG directive");
    }
    try {
      prefix = decodeURIComponent(prefix);
    } catch (err) {
      throwError(state, "tag prefix is malformed: " + prefix);
    }
    state.tagMap[handle] = prefix;
  }
};
function captureSegment(state, start, end, checkJson) {
  var _position, _length, _character, _result;
  if (start < end) {
    _result = state.input.slice(start, end);
    if (checkJson) {
      for (_position = 0, _length = _result.length; _position < _length; _position += 1) {
        _character = _result.charCodeAt(_position);
        if (!(_character === 9 || 32 <= _character && _character <= 1114111)) {
          throwError(state, "expected valid JSON character");
        }
      }
    } else if (PATTERN_NON_PRINTABLE.test(_result)) {
      throwError(state, "the stream contains non-printable characters");
    }
    state.result += _result;
  }
}
function mergeMappings(state, destination, source, overridableKeys) {
  var sourceKeys, key, index, quantity;
  if (!common.isObject(source)) {
    throwError(state, "cannot merge mappings; the provided source object is unacceptable");
  }
  sourceKeys = Object.keys(source);
  for (index = 0, quantity = sourceKeys.length; index < quantity; index += 1) {
    key = sourceKeys[index];
    if (!_hasOwnProperty$1.call(destination, key)) {
      setProperty(destination, key, source[key]);
      overridableKeys[key] = true;
    }
  }
}
function storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode, startLine, startLineStart, startPos) {
  var index, quantity;
  if (Array.isArray(keyNode)) {
    keyNode = Array.prototype.slice.call(keyNode);
    for (index = 0, quantity = keyNode.length; index < quantity; index += 1) {
      if (Array.isArray(keyNode[index])) {
        throwError(state, "nested arrays are not supported inside keys");
      }
      if (typeof keyNode === "object" && _class(keyNode[index]) === "[object Object]") {
        keyNode[index] = "[object Object]";
      }
    }
  }
  if (typeof keyNode === "object" && _class(keyNode) === "[object Object]") {
    keyNode = "[object Object]";
  }
  keyNode = String(keyNode);
  if (_result === null) {
    _result = {};
  }
  if (keyTag === "tag:yaml.org,2002:merge") {
    if (Array.isArray(valueNode)) {
      for (index = 0, quantity = valueNode.length; index < quantity; index += 1) {
        mergeMappings(state, _result, valueNode[index], overridableKeys);
      }
    } else {
      mergeMappings(state, _result, valueNode, overridableKeys);
    }
  } else {
    if (!state.json && !_hasOwnProperty$1.call(overridableKeys, keyNode) && _hasOwnProperty$1.call(_result, keyNode)) {
      state.line = startLine || state.line;
      state.lineStart = startLineStart || state.lineStart;
      state.position = startPos || state.position;
      throwError(state, "duplicated mapping key");
    }
    setProperty(_result, keyNode, valueNode);
    delete overridableKeys[keyNode];
  }
  return _result;
}
function readLineBreak(state) {
  var ch;
  ch = state.input.charCodeAt(state.position);
  if (ch === 10) {
    state.position++;
  } else if (ch === 13) {
    state.position++;
    if (state.input.charCodeAt(state.position) === 10) {
      state.position++;
    }
  } else {
    throwError(state, "a line break is expected");
  }
  state.line += 1;
  state.lineStart = state.position;
  state.firstTabInLine = -1;
}
function skipSeparationSpace(state, allowComments, checkIndent) {
  var lineBreaks = 0, ch = state.input.charCodeAt(state.position);
  while (ch !== 0) {
    while (is_WHITE_SPACE(ch)) {
      if (ch === 9 && state.firstTabInLine === -1) {
        state.firstTabInLine = state.position;
      }
      ch = state.input.charCodeAt(++state.position);
    }
    if (allowComments && ch === 35) {
      do {
        ch = state.input.charCodeAt(++state.position);
      } while (ch !== 10 && ch !== 13 && ch !== 0);
    }
    if (is_EOL(ch)) {
      readLineBreak(state);
      ch = state.input.charCodeAt(state.position);
      lineBreaks++;
      state.lineIndent = 0;
      while (ch === 32) {
        state.lineIndent++;
        ch = state.input.charCodeAt(++state.position);
      }
    } else {
      break;
    }
  }
  if (checkIndent !== -1 && lineBreaks !== 0 && state.lineIndent < checkIndent) {
    throwWarning(state, "deficient indentation");
  }
  return lineBreaks;
}
function testDocumentSeparator(state) {
  var _position = state.position, ch;
  ch = state.input.charCodeAt(_position);
  if ((ch === 45 || ch === 46) && ch === state.input.charCodeAt(_position + 1) && ch === state.input.charCodeAt(_position + 2)) {
    _position += 3;
    ch = state.input.charCodeAt(_position);
    if (ch === 0 || is_WS_OR_EOL(ch)) {
      return true;
    }
  }
  return false;
}
function writeFoldedLines(state, count) {
  if (count === 1) {
    state.result += " ";
  } else if (count > 1) {
    state.result += common.repeat("\n", count - 1);
  }
}
function readPlainScalar(state, nodeIndent, withinFlowCollection) {
  var preceding, following, captureStart, captureEnd, hasPendingContent, _line, _lineStart, _lineIndent, _kind = state.kind, _result = state.result, ch;
  ch = state.input.charCodeAt(state.position);
  if (is_WS_OR_EOL(ch) || is_FLOW_INDICATOR(ch) || ch === 35 || ch === 38 || ch === 42 || ch === 33 || ch === 124 || ch === 62 || ch === 39 || ch === 34 || ch === 37 || ch === 64 || ch === 96) {
    return false;
  }
  if (ch === 63 || ch === 45) {
    following = state.input.charCodeAt(state.position + 1);
    if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
      return false;
    }
  }
  state.kind = "scalar";
  state.result = "";
  captureStart = captureEnd = state.position;
  hasPendingContent = false;
  while (ch !== 0) {
    if (ch === 58) {
      following = state.input.charCodeAt(state.position + 1);
      if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
        break;
      }
    } else if (ch === 35) {
      preceding = state.input.charCodeAt(state.position - 1);
      if (is_WS_OR_EOL(preceding)) {
        break;
      }
    } else if (state.position === state.lineStart && testDocumentSeparator(state) || withinFlowCollection && is_FLOW_INDICATOR(ch)) {
      break;
    } else if (is_EOL(ch)) {
      _line = state.line;
      _lineStart = state.lineStart;
      _lineIndent = state.lineIndent;
      skipSeparationSpace(state, false, -1);
      if (state.lineIndent >= nodeIndent) {
        hasPendingContent = true;
        ch = state.input.charCodeAt(state.position);
        continue;
      } else {
        state.position = captureEnd;
        state.line = _line;
        state.lineStart = _lineStart;
        state.lineIndent = _lineIndent;
        break;
      }
    }
    if (hasPendingContent) {
      captureSegment(state, captureStart, captureEnd, false);
      writeFoldedLines(state, state.line - _line);
      captureStart = captureEnd = state.position;
      hasPendingContent = false;
    }
    if (!is_WHITE_SPACE(ch)) {
      captureEnd = state.position + 1;
    }
    ch = state.input.charCodeAt(++state.position);
  }
  captureSegment(state, captureStart, captureEnd, false);
  if (state.result) {
    return true;
  }
  state.kind = _kind;
  state.result = _result;
  return false;
}
function readSingleQuotedScalar(state, nodeIndent) {
  var ch, captureStart, captureEnd;
  ch = state.input.charCodeAt(state.position);
  if (ch !== 39) {
    return false;
  }
  state.kind = "scalar";
  state.result = "";
  state.position++;
  captureStart = captureEnd = state.position;
  while ((ch = state.input.charCodeAt(state.position)) !== 0) {
    if (ch === 39) {
      captureSegment(state, captureStart, state.position, true);
      ch = state.input.charCodeAt(++state.position);
      if (ch === 39) {
        captureStart = state.position;
        state.position++;
        captureEnd = state.position;
      } else {
        return true;
      }
    } else if (is_EOL(ch)) {
      captureSegment(state, captureStart, captureEnd, true);
      writeFoldedLines(state, skipSeparationSpace(state, false, nodeIndent));
      captureStart = captureEnd = state.position;
    } else if (state.position === state.lineStart && testDocumentSeparator(state)) {
      throwError(state, "unexpected end of the document within a single quoted scalar");
    } else {
      state.position++;
      captureEnd = state.position;
    }
  }
  throwError(state, "unexpected end of the stream within a single quoted scalar");
}
function readDoubleQuotedScalar(state, nodeIndent) {
  var captureStart, captureEnd, hexLength, hexResult, tmp, ch;
  ch = state.input.charCodeAt(state.position);
  if (ch !== 34) {
    return false;
  }
  state.kind = "scalar";
  state.result = "";
  state.position++;
  captureStart = captureEnd = state.position;
  while ((ch = state.input.charCodeAt(state.position)) !== 0) {
    if (ch === 34) {
      captureSegment(state, captureStart, state.position, true);
      state.position++;
      return true;
    } else if (ch === 92) {
      captureSegment(state, captureStart, state.position, true);
      ch = state.input.charCodeAt(++state.position);
      if (is_EOL(ch)) {
        skipSeparationSpace(state, false, nodeIndent);
      } else if (ch < 256 && simpleEscapeCheck[ch]) {
        state.result += simpleEscapeMap[ch];
        state.position++;
      } else if ((tmp = escapedHexLen(ch)) > 0) {
        hexLength = tmp;
        hexResult = 0;
        for (; hexLength > 0; hexLength--) {
          ch = state.input.charCodeAt(++state.position);
          if ((tmp = fromHexCode(ch)) >= 0) {
            hexResult = (hexResult << 4) + tmp;
          } else {
            throwError(state, "expected hexadecimal character");
          }
        }
        state.result += charFromCodepoint(hexResult);
        state.position++;
      } else {
        throwError(state, "unknown escape sequence");
      }
      captureStart = captureEnd = state.position;
    } else if (is_EOL(ch)) {
      captureSegment(state, captureStart, captureEnd, true);
      writeFoldedLines(state, skipSeparationSpace(state, false, nodeIndent));
      captureStart = captureEnd = state.position;
    } else if (state.position === state.lineStart && testDocumentSeparator(state)) {
      throwError(state, "unexpected end of the document within a double quoted scalar");
    } else {
      state.position++;
      captureEnd = state.position;
    }
  }
  throwError(state, "unexpected end of the stream within a double quoted scalar");
}
function readFlowCollection(state, nodeIndent) {
  var readNext = true, _line, _lineStart, _pos, _tag = state.tag, _result, _anchor = state.anchor, following, terminator, isPair, isExplicitPair, isMapping, overridableKeys = /* @__PURE__ */ Object.create(null), keyNode, keyTag, valueNode, ch;
  ch = state.input.charCodeAt(state.position);
  if (ch === 91) {
    terminator = 93;
    isMapping = false;
    _result = [];
  } else if (ch === 123) {
    terminator = 125;
    isMapping = true;
    _result = {};
  } else {
    return false;
  }
  if (state.anchor !== null) {
    state.anchorMap[state.anchor] = _result;
  }
  ch = state.input.charCodeAt(++state.position);
  while (ch !== 0) {
    skipSeparationSpace(state, true, nodeIndent);
    ch = state.input.charCodeAt(state.position);
    if (ch === terminator) {
      state.position++;
      state.tag = _tag;
      state.anchor = _anchor;
      state.kind = isMapping ? "mapping" : "sequence";
      state.result = _result;
      return true;
    } else if (!readNext) {
      throwError(state, "missed comma between flow collection entries");
    } else if (ch === 44) {
      throwError(state, "expected the node content, but found ','");
    }
    keyTag = keyNode = valueNode = null;
    isPair = isExplicitPair = false;
    if (ch === 63) {
      following = state.input.charCodeAt(state.position + 1);
      if (is_WS_OR_EOL(following)) {
        isPair = isExplicitPair = true;
        state.position++;
        skipSeparationSpace(state, true, nodeIndent);
      }
    }
    _line = state.line;
    _lineStart = state.lineStart;
    _pos = state.position;
    composeNode(state, nodeIndent, CONTEXT_FLOW_IN, false, true);
    keyTag = state.tag;
    keyNode = state.result;
    skipSeparationSpace(state, true, nodeIndent);
    ch = state.input.charCodeAt(state.position);
    if ((isExplicitPair || state.line === _line) && ch === 58) {
      isPair = true;
      ch = state.input.charCodeAt(++state.position);
      skipSeparationSpace(state, true, nodeIndent);
      composeNode(state, nodeIndent, CONTEXT_FLOW_IN, false, true);
      valueNode = state.result;
    }
    if (isMapping) {
      storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos);
    } else if (isPair) {
      _result.push(storeMappingPair(state, null, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos));
    } else {
      _result.push(keyNode);
    }
    skipSeparationSpace(state, true, nodeIndent);
    ch = state.input.charCodeAt(state.position);
    if (ch === 44) {
      readNext = true;
      ch = state.input.charCodeAt(++state.position);
    } else {
      readNext = false;
    }
  }
  throwError(state, "unexpected end of the stream within a flow collection");
}
function readBlockScalar(state, nodeIndent) {
  var captureStart, folding, chomping = CHOMPING_CLIP, didReadContent = false, detectedIndent = false, textIndent = nodeIndent, emptyLines = 0, atMoreIndented = false, tmp, ch;
  ch = state.input.charCodeAt(state.position);
  if (ch === 124) {
    folding = false;
  } else if (ch === 62) {
    folding = true;
  } else {
    return false;
  }
  state.kind = "scalar";
  state.result = "";
  while (ch !== 0) {
    ch = state.input.charCodeAt(++state.position);
    if (ch === 43 || ch === 45) {
      if (CHOMPING_CLIP === chomping) {
        chomping = ch === 43 ? CHOMPING_KEEP : CHOMPING_STRIP;
      } else {
        throwError(state, "repeat of a chomping mode identifier");
      }
    } else if ((tmp = fromDecimalCode(ch)) >= 0) {
      if (tmp === 0) {
        throwError(state, "bad explicit indentation width of a block scalar; it cannot be less than one");
      } else if (!detectedIndent) {
        textIndent = nodeIndent + tmp - 1;
        detectedIndent = true;
      } else {
        throwError(state, "repeat of an indentation width identifier");
      }
    } else {
      break;
    }
  }
  if (is_WHITE_SPACE(ch)) {
    do {
      ch = state.input.charCodeAt(++state.position);
    } while (is_WHITE_SPACE(ch));
    if (ch === 35) {
      do {
        ch = state.input.charCodeAt(++state.position);
      } while (!is_EOL(ch) && ch !== 0);
    }
  }
  while (ch !== 0) {
    readLineBreak(state);
    state.lineIndent = 0;
    ch = state.input.charCodeAt(state.position);
    while ((!detectedIndent || state.lineIndent < textIndent) && ch === 32) {
      state.lineIndent++;
      ch = state.input.charCodeAt(++state.position);
    }
    if (!detectedIndent && state.lineIndent > textIndent) {
      textIndent = state.lineIndent;
    }
    if (is_EOL(ch)) {
      emptyLines++;
      continue;
    }
    if (state.lineIndent < textIndent) {
      if (chomping === CHOMPING_KEEP) {
        state.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
      } else if (chomping === CHOMPING_CLIP) {
        if (didReadContent) {
          state.result += "\n";
        }
      }
      break;
    }
    if (folding) {
      if (is_WHITE_SPACE(ch)) {
        atMoreIndented = true;
        state.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
      } else if (atMoreIndented) {
        atMoreIndented = false;
        state.result += common.repeat("\n", emptyLines + 1);
      } else if (emptyLines === 0) {
        if (didReadContent) {
          state.result += " ";
        }
      } else {
        state.result += common.repeat("\n", emptyLines);
      }
    } else {
      state.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
    }
    didReadContent = true;
    detectedIndent = true;
    emptyLines = 0;
    captureStart = state.position;
    while (!is_EOL(ch) && ch !== 0) {
      ch = state.input.charCodeAt(++state.position);
    }
    captureSegment(state, captureStart, state.position, false);
  }
  return true;
}
function readBlockSequence(state, nodeIndent) {
  var _line, _tag = state.tag, _anchor = state.anchor, _result = [], following, detected = false, ch;
  if (state.firstTabInLine !== -1)
    return false;
  if (state.anchor !== null) {
    state.anchorMap[state.anchor] = _result;
  }
  ch = state.input.charCodeAt(state.position);
  while (ch !== 0) {
    if (state.firstTabInLine !== -1) {
      state.position = state.firstTabInLine;
      throwError(state, "tab characters must not be used in indentation");
    }
    if (ch !== 45) {
      break;
    }
    following = state.input.charCodeAt(state.position + 1);
    if (!is_WS_OR_EOL(following)) {
      break;
    }
    detected = true;
    state.position++;
    if (skipSeparationSpace(state, true, -1)) {
      if (state.lineIndent <= nodeIndent) {
        _result.push(null);
        ch = state.input.charCodeAt(state.position);
        continue;
      }
    }
    _line = state.line;
    composeNode(state, nodeIndent, CONTEXT_BLOCK_IN, false, true);
    _result.push(state.result);
    skipSeparationSpace(state, true, -1);
    ch = state.input.charCodeAt(state.position);
    if ((state.line === _line || state.lineIndent > nodeIndent) && ch !== 0) {
      throwError(state, "bad indentation of a sequence entry");
    } else if (state.lineIndent < nodeIndent) {
      break;
    }
  }
  if (detected) {
    state.tag = _tag;
    state.anchor = _anchor;
    state.kind = "sequence";
    state.result = _result;
    return true;
  }
  return false;
}
function readBlockMapping(state, nodeIndent, flowIndent) {
  var following, allowCompact, _line, _keyLine, _keyLineStart, _keyPos, _tag = state.tag, _anchor = state.anchor, _result = {}, overridableKeys = /* @__PURE__ */ Object.create(null), keyTag = null, keyNode = null, valueNode = null, atExplicitKey = false, detected = false, ch;
  if (state.firstTabInLine !== -1)
    return false;
  if (state.anchor !== null) {
    state.anchorMap[state.anchor] = _result;
  }
  ch = state.input.charCodeAt(state.position);
  while (ch !== 0) {
    if (!atExplicitKey && state.firstTabInLine !== -1) {
      state.position = state.firstTabInLine;
      throwError(state, "tab characters must not be used in indentation");
    }
    following = state.input.charCodeAt(state.position + 1);
    _line = state.line;
    if ((ch === 63 || ch === 58) && is_WS_OR_EOL(following)) {
      if (ch === 63) {
        if (atExplicitKey) {
          storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
          keyTag = keyNode = valueNode = null;
        }
        detected = true;
        atExplicitKey = true;
        allowCompact = true;
      } else if (atExplicitKey) {
        atExplicitKey = false;
        allowCompact = true;
      } else {
        throwError(state, "incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line");
      }
      state.position += 1;
      ch = following;
    } else {
      _keyLine = state.line;
      _keyLineStart = state.lineStart;
      _keyPos = state.position;
      if (!composeNode(state, flowIndent, CONTEXT_FLOW_OUT, false, true)) {
        break;
      }
      if (state.line === _line) {
        ch = state.input.charCodeAt(state.position);
        while (is_WHITE_SPACE(ch)) {
          ch = state.input.charCodeAt(++state.position);
        }
        if (ch === 58) {
          ch = state.input.charCodeAt(++state.position);
          if (!is_WS_OR_EOL(ch)) {
            throwError(state, "a whitespace character is expected after the key-value separator within a block mapping");
          }
          if (atExplicitKey) {
            storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
            keyTag = keyNode = valueNode = null;
          }
          detected = true;
          atExplicitKey = false;
          allowCompact = false;
          keyTag = state.tag;
          keyNode = state.result;
        } else if (detected) {
          throwError(state, "can not read an implicit mapping pair; a colon is missed");
        } else {
          state.tag = _tag;
          state.anchor = _anchor;
          return true;
        }
      } else if (detected) {
        throwError(state, "can not read a block mapping entry; a multiline key may not be an implicit key");
      } else {
        state.tag = _tag;
        state.anchor = _anchor;
        return true;
      }
    }
    if (state.line === _line || state.lineIndent > nodeIndent) {
      if (atExplicitKey) {
        _keyLine = state.line;
        _keyLineStart = state.lineStart;
        _keyPos = state.position;
      }
      if (composeNode(state, nodeIndent, CONTEXT_BLOCK_OUT, true, allowCompact)) {
        if (atExplicitKey) {
          keyNode = state.result;
        } else {
          valueNode = state.result;
        }
      }
      if (!atExplicitKey) {
        storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode, _keyLine, _keyLineStart, _keyPos);
        keyTag = keyNode = valueNode = null;
      }
      skipSeparationSpace(state, true, -1);
      ch = state.input.charCodeAt(state.position);
    }
    if ((state.line === _line || state.lineIndent > nodeIndent) && ch !== 0) {
      throwError(state, "bad indentation of a mapping entry");
    } else if (state.lineIndent < nodeIndent) {
      break;
    }
  }
  if (atExplicitKey) {
    storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
  }
  if (detected) {
    state.tag = _tag;
    state.anchor = _anchor;
    state.kind = "mapping";
    state.result = _result;
  }
  return detected;
}
function readTagProperty(state) {
  var _position, isVerbatim = false, isNamed = false, tagHandle, tagName, ch;
  ch = state.input.charCodeAt(state.position);
  if (ch !== 33)
    return false;
  if (state.tag !== null) {
    throwError(state, "duplication of a tag property");
  }
  ch = state.input.charCodeAt(++state.position);
  if (ch === 60) {
    isVerbatim = true;
    ch = state.input.charCodeAt(++state.position);
  } else if (ch === 33) {
    isNamed = true;
    tagHandle = "!!";
    ch = state.input.charCodeAt(++state.position);
  } else {
    tagHandle = "!";
  }
  _position = state.position;
  if (isVerbatim) {
    do {
      ch = state.input.charCodeAt(++state.position);
    } while (ch !== 0 && ch !== 62);
    if (state.position < state.length) {
      tagName = state.input.slice(_position, state.position);
      ch = state.input.charCodeAt(++state.position);
    } else {
      throwError(state, "unexpected end of the stream within a verbatim tag");
    }
  } else {
    while (ch !== 0 && !is_WS_OR_EOL(ch)) {
      if (ch === 33) {
        if (!isNamed) {
          tagHandle = state.input.slice(_position - 1, state.position + 1);
          if (!PATTERN_TAG_HANDLE.test(tagHandle)) {
            throwError(state, "named tag handle cannot contain such characters");
          }
          isNamed = true;
          _position = state.position + 1;
        } else {
          throwError(state, "tag suffix cannot contain exclamation marks");
        }
      }
      ch = state.input.charCodeAt(++state.position);
    }
    tagName = state.input.slice(_position, state.position);
    if (PATTERN_FLOW_INDICATORS.test(tagName)) {
      throwError(state, "tag suffix cannot contain flow indicator characters");
    }
  }
  if (tagName && !PATTERN_TAG_URI.test(tagName)) {
    throwError(state, "tag name cannot contain such characters: " + tagName);
  }
  try {
    tagName = decodeURIComponent(tagName);
  } catch (err) {
    throwError(state, "tag name is malformed: " + tagName);
  }
  if (isVerbatim) {
    state.tag = tagName;
  } else if (_hasOwnProperty$1.call(state.tagMap, tagHandle)) {
    state.tag = state.tagMap[tagHandle] + tagName;
  } else if (tagHandle === "!") {
    state.tag = "!" + tagName;
  } else if (tagHandle === "!!") {
    state.tag = "tag:yaml.org,2002:" + tagName;
  } else {
    throwError(state, 'undeclared tag handle "' + tagHandle + '"');
  }
  return true;
}
function readAnchorProperty(state) {
  var _position, ch;
  ch = state.input.charCodeAt(state.position);
  if (ch !== 38)
    return false;
  if (state.anchor !== null) {
    throwError(state, "duplication of an anchor property");
  }
  ch = state.input.charCodeAt(++state.position);
  _position = state.position;
  while (ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)) {
    ch = state.input.charCodeAt(++state.position);
  }
  if (state.position === _position) {
    throwError(state, "name of an anchor node must contain at least one character");
  }
  state.anchor = state.input.slice(_position, state.position);
  return true;
}
function readAlias(state) {
  var _position, alias, ch;
  ch = state.input.charCodeAt(state.position);
  if (ch !== 42)
    return false;
  ch = state.input.charCodeAt(++state.position);
  _position = state.position;
  while (ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)) {
    ch = state.input.charCodeAt(++state.position);
  }
  if (state.position === _position) {
    throwError(state, "name of an alias node must contain at least one character");
  }
  alias = state.input.slice(_position, state.position);
  if (!_hasOwnProperty$1.call(state.anchorMap, alias)) {
    throwError(state, 'unidentified alias "' + alias + '"');
  }
  state.result = state.anchorMap[alias];
  skipSeparationSpace(state, true, -1);
  return true;
}
function composeNode(state, parentIndent, nodeContext, allowToSeek, allowCompact) {
  var allowBlockStyles, allowBlockScalars, allowBlockCollections, indentStatus = 1, atNewLine = false, hasContent = false, typeIndex, typeQuantity, typeList, type2, flowIndent, blockIndent;
  if (state.listener !== null) {
    state.listener("open", state);
  }
  state.tag = null;
  state.anchor = null;
  state.kind = null;
  state.result = null;
  allowBlockStyles = allowBlockScalars = allowBlockCollections = CONTEXT_BLOCK_OUT === nodeContext || CONTEXT_BLOCK_IN === nodeContext;
  if (allowToSeek) {
    if (skipSeparationSpace(state, true, -1)) {
      atNewLine = true;
      if (state.lineIndent > parentIndent) {
        indentStatus = 1;
      } else if (state.lineIndent === parentIndent) {
        indentStatus = 0;
      } else if (state.lineIndent < parentIndent) {
        indentStatus = -1;
      }
    }
  }
  if (indentStatus === 1) {
    while (readTagProperty(state) || readAnchorProperty(state)) {
      if (skipSeparationSpace(state, true, -1)) {
        atNewLine = true;
        allowBlockCollections = allowBlockStyles;
        if (state.lineIndent > parentIndent) {
          indentStatus = 1;
        } else if (state.lineIndent === parentIndent) {
          indentStatus = 0;
        } else if (state.lineIndent < parentIndent) {
          indentStatus = -1;
        }
      } else {
        allowBlockCollections = false;
      }
    }
  }
  if (allowBlockCollections) {
    allowBlockCollections = atNewLine || allowCompact;
  }
  if (indentStatus === 1 || CONTEXT_BLOCK_OUT === nodeContext) {
    if (CONTEXT_FLOW_IN === nodeContext || CONTEXT_FLOW_OUT === nodeContext) {
      flowIndent = parentIndent;
    } else {
      flowIndent = parentIndent + 1;
    }
    blockIndent = state.position - state.lineStart;
    if (indentStatus === 1) {
      if (allowBlockCollections && (readBlockSequence(state, blockIndent) || readBlockMapping(state, blockIndent, flowIndent)) || readFlowCollection(state, flowIndent)) {
        hasContent = true;
      } else {
        if (allowBlockScalars && readBlockScalar(state, flowIndent) || readSingleQuotedScalar(state, flowIndent) || readDoubleQuotedScalar(state, flowIndent)) {
          hasContent = true;
        } else if (readAlias(state)) {
          hasContent = true;
          if (state.tag !== null || state.anchor !== null) {
            throwError(state, "alias node should not have any properties");
          }
        } else if (readPlainScalar(state, flowIndent, CONTEXT_FLOW_IN === nodeContext)) {
          hasContent = true;
          if (state.tag === null) {
            state.tag = "?";
          }
        }
        if (state.anchor !== null) {
          state.anchorMap[state.anchor] = state.result;
        }
      }
    } else if (indentStatus === 0) {
      hasContent = allowBlockCollections && readBlockSequence(state, blockIndent);
    }
  }
  if (state.tag === null) {
    if (state.anchor !== null) {
      state.anchorMap[state.anchor] = state.result;
    }
  } else if (state.tag === "?") {
    if (state.result !== null && state.kind !== "scalar") {
      throwError(state, 'unacceptable node kind for !<?> tag; it should be "scalar", not "' + state.kind + '"');
    }
    for (typeIndex = 0, typeQuantity = state.implicitTypes.length; typeIndex < typeQuantity; typeIndex += 1) {
      type2 = state.implicitTypes[typeIndex];
      if (type2.resolve(state.result)) {
        state.result = type2.construct(state.result);
        state.tag = type2.tag;
        if (state.anchor !== null) {
          state.anchorMap[state.anchor] = state.result;
        }
        break;
      }
    }
  } else if (state.tag !== "!") {
    if (_hasOwnProperty$1.call(state.typeMap[state.kind || "fallback"], state.tag)) {
      type2 = state.typeMap[state.kind || "fallback"][state.tag];
    } else {
      type2 = null;
      typeList = state.typeMap.multi[state.kind || "fallback"];
      for (typeIndex = 0, typeQuantity = typeList.length; typeIndex < typeQuantity; typeIndex += 1) {
        if (state.tag.slice(0, typeList[typeIndex].tag.length) === typeList[typeIndex].tag) {
          type2 = typeList[typeIndex];
          break;
        }
      }
    }
    if (!type2) {
      throwError(state, "unknown tag !<" + state.tag + ">");
    }
    if (state.result !== null && type2.kind !== state.kind) {
      throwError(state, "unacceptable node kind for !<" + state.tag + '> tag; it should be "' + type2.kind + '", not "' + state.kind + '"');
    }
    if (!type2.resolve(state.result, state.tag)) {
      throwError(state, "cannot resolve a node with !<" + state.tag + "> explicit tag");
    } else {
      state.result = type2.construct(state.result, state.tag);
      if (state.anchor !== null) {
        state.anchorMap[state.anchor] = state.result;
      }
    }
  }
  if (state.listener !== null) {
    state.listener("close", state);
  }
  return state.tag !== null || state.anchor !== null || hasContent;
}
function readDocument(state) {
  var documentStart = state.position, _position, directiveName, directiveArgs, hasDirectives = false, ch;
  state.version = null;
  state.checkLineBreaks = state.legacy;
  state.tagMap = /* @__PURE__ */ Object.create(null);
  state.anchorMap = /* @__PURE__ */ Object.create(null);
  while ((ch = state.input.charCodeAt(state.position)) !== 0) {
    skipSeparationSpace(state, true, -1);
    ch = state.input.charCodeAt(state.position);
    if (state.lineIndent > 0 || ch !== 37) {
      break;
    }
    hasDirectives = true;
    ch = state.input.charCodeAt(++state.position);
    _position = state.position;
    while (ch !== 0 && !is_WS_OR_EOL(ch)) {
      ch = state.input.charCodeAt(++state.position);
    }
    directiveName = state.input.slice(_position, state.position);
    directiveArgs = [];
    if (directiveName.length < 1) {
      throwError(state, "directive name must not be less than one character in length");
    }
    while (ch !== 0) {
      while (is_WHITE_SPACE(ch)) {
        ch = state.input.charCodeAt(++state.position);
      }
      if (ch === 35) {
        do {
          ch = state.input.charCodeAt(++state.position);
        } while (ch !== 0 && !is_EOL(ch));
        break;
      }
      if (is_EOL(ch))
        break;
      _position = state.position;
      while (ch !== 0 && !is_WS_OR_EOL(ch)) {
        ch = state.input.charCodeAt(++state.position);
      }
      directiveArgs.push(state.input.slice(_position, state.position));
    }
    if (ch !== 0)
      readLineBreak(state);
    if (_hasOwnProperty$1.call(directiveHandlers, directiveName)) {
      directiveHandlers[directiveName](state, directiveName, directiveArgs);
    } else {
      throwWarning(state, 'unknown document directive "' + directiveName + '"');
    }
  }
  skipSeparationSpace(state, true, -1);
  if (state.lineIndent === 0 && state.input.charCodeAt(state.position) === 45 && state.input.charCodeAt(state.position + 1) === 45 && state.input.charCodeAt(state.position + 2) === 45) {
    state.position += 3;
    skipSeparationSpace(state, true, -1);
  } else if (hasDirectives) {
    throwError(state, "directives end mark is expected");
  }
  composeNode(state, state.lineIndent - 1, CONTEXT_BLOCK_OUT, false, true);
  skipSeparationSpace(state, true, -1);
  if (state.checkLineBreaks && PATTERN_NON_ASCII_LINE_BREAKS.test(state.input.slice(documentStart, state.position))) {
    throwWarning(state, "non-ASCII line breaks are interpreted as content");
  }
  state.documents.push(state.result);
  if (state.position === state.lineStart && testDocumentSeparator(state)) {
    if (state.input.charCodeAt(state.position) === 46) {
      state.position += 3;
      skipSeparationSpace(state, true, -1);
    }
    return;
  }
  if (state.position < state.length - 1) {
    throwError(state, "end of the stream or a document separator is expected");
  } else {
    return;
  }
}
function loadDocuments(input, options) {
  input = String(input);
  options = options || {};
  if (input.length !== 0) {
    if (input.charCodeAt(input.length - 1) !== 10 && input.charCodeAt(input.length - 1) !== 13) {
      input += "\n";
    }
    if (input.charCodeAt(0) === 65279) {
      input = input.slice(1);
    }
  }
  var state = new State$1(input, options);
  var nullpos = input.indexOf("\0");
  if (nullpos !== -1) {
    state.position = nullpos;
    throwError(state, "null byte is not allowed in input");
  }
  state.input += "\0";
  while (state.input.charCodeAt(state.position) === 32) {
    state.lineIndent += 1;
    state.position += 1;
  }
  while (state.position < state.length - 1) {
    readDocument(state);
  }
  return state.documents;
}
function loadAll$1(input, iterator, options) {
  if (iterator !== null && typeof iterator === "object" && typeof options === "undefined") {
    options = iterator;
    iterator = null;
  }
  var documents = loadDocuments(input, options);
  if (typeof iterator !== "function") {
    return documents;
  }
  for (var index = 0, length = documents.length; index < length; index += 1) {
    iterator(documents[index]);
  }
}
function load$1(input, options) {
  var documents = loadDocuments(input, options);
  if (documents.length === 0) {
    return void 0;
  } else if (documents.length === 1) {
    return documents[0];
  }
  throw new exception("expected a single document in the stream, but found more");
}
var loadAll_1 = loadAll$1;
var load_1 = load$1;
var loader = {
  loadAll: loadAll_1,
  load: load_1
};
var _toString = Object.prototype.toString;
var _hasOwnProperty = Object.prototype.hasOwnProperty;
var CHAR_BOM = 65279;
var CHAR_TAB = 9;
var CHAR_LINE_FEED = 10;
var CHAR_CARRIAGE_RETURN = 13;
var CHAR_SPACE = 32;
var CHAR_EXCLAMATION = 33;
var CHAR_DOUBLE_QUOTE = 34;
var CHAR_SHARP = 35;
var CHAR_PERCENT = 37;
var CHAR_AMPERSAND = 38;
var CHAR_SINGLE_QUOTE = 39;
var CHAR_ASTERISK = 42;
var CHAR_COMMA = 44;
var CHAR_MINUS = 45;
var CHAR_COLON = 58;
var CHAR_EQUALS = 61;
var CHAR_GREATER_THAN = 62;
var CHAR_QUESTION = 63;
var CHAR_COMMERCIAL_AT = 64;
var CHAR_LEFT_SQUARE_BRACKET = 91;
var CHAR_RIGHT_SQUARE_BRACKET = 93;
var CHAR_GRAVE_ACCENT = 96;
var CHAR_LEFT_CURLY_BRACKET = 123;
var CHAR_VERTICAL_LINE = 124;
var CHAR_RIGHT_CURLY_BRACKET = 125;
var ESCAPE_SEQUENCES = {};
ESCAPE_SEQUENCES[0] = "\\0";
ESCAPE_SEQUENCES[7] = "\\a";
ESCAPE_SEQUENCES[8] = "\\b";
ESCAPE_SEQUENCES[9] = "\\t";
ESCAPE_SEQUENCES[10] = "\\n";
ESCAPE_SEQUENCES[11] = "\\v";
ESCAPE_SEQUENCES[12] = "\\f";
ESCAPE_SEQUENCES[13] = "\\r";
ESCAPE_SEQUENCES[27] = "\\e";
ESCAPE_SEQUENCES[34] = '\\"';
ESCAPE_SEQUENCES[92] = "\\\\";
ESCAPE_SEQUENCES[133] = "\\N";
ESCAPE_SEQUENCES[160] = "\\_";
ESCAPE_SEQUENCES[8232] = "\\L";
ESCAPE_SEQUENCES[8233] = "\\P";
var DEPRECATED_BOOLEANS_SYNTAX = [
  "y",
  "Y",
  "yes",
  "Yes",
  "YES",
  "on",
  "On",
  "ON",
  "n",
  "N",
  "no",
  "No",
  "NO",
  "off",
  "Off",
  "OFF"
];
var DEPRECATED_BASE60_SYNTAX = /^[-+]?[0-9_]+(?::[0-9_]+)+(?:\.[0-9_]*)?$/;
function compileStyleMap(schema2, map2) {
  var result, keys, index, length, tag, style, type2;
  if (map2 === null)
    return {};
  result = {};
  keys = Object.keys(map2);
  for (index = 0, length = keys.length; index < length; index += 1) {
    tag = keys[index];
    style = String(map2[tag]);
    if (tag.slice(0, 2) === "!!") {
      tag = "tag:yaml.org,2002:" + tag.slice(2);
    }
    type2 = schema2.compiledTypeMap["fallback"][tag];
    if (type2 && _hasOwnProperty.call(type2.styleAliases, style)) {
      style = type2.styleAliases[style];
    }
    result[tag] = style;
  }
  return result;
}
function encodeHex(character) {
  var string, handle, length;
  string = character.toString(16).toUpperCase();
  if (character <= 255) {
    handle = "x";
    length = 2;
  } else if (character <= 65535) {
    handle = "u";
    length = 4;
  } else if (character <= 4294967295) {
    handle = "U";
    length = 8;
  } else {
    throw new exception("code point within a string may not be greater than 0xFFFFFFFF");
  }
  return "\\" + handle + common.repeat("0", length - string.length) + string;
}
var QUOTING_TYPE_SINGLE = 1;
var QUOTING_TYPE_DOUBLE = 2;
function State(options) {
  this.schema = options["schema"] || _default;
  this.indent = Math.max(1, options["indent"] || 2);
  this.noArrayIndent = options["noArrayIndent"] || false;
  this.skipInvalid = options["skipInvalid"] || false;
  this.flowLevel = common.isNothing(options["flowLevel"]) ? -1 : options["flowLevel"];
  this.styleMap = compileStyleMap(this.schema, options["styles"] || null);
  this.sortKeys = options["sortKeys"] || false;
  this.lineWidth = options["lineWidth"] || 80;
  this.noRefs = options["noRefs"] || false;
  this.noCompatMode = options["noCompatMode"] || false;
  this.condenseFlow = options["condenseFlow"] || false;
  this.quotingType = options["quotingType"] === '"' ? QUOTING_TYPE_DOUBLE : QUOTING_TYPE_SINGLE;
  this.forceQuotes = options["forceQuotes"] || false;
  this.replacer = typeof options["replacer"] === "function" ? options["replacer"] : null;
  this.implicitTypes = this.schema.compiledImplicit;
  this.explicitTypes = this.schema.compiledExplicit;
  this.tag = null;
  this.result = "";
  this.duplicates = [];
  this.usedDuplicates = null;
}
function indentString(string, spaces) {
  var ind = common.repeat(" ", spaces), position = 0, next = -1, result = "", line, length = string.length;
  while (position < length) {
    next = string.indexOf("\n", position);
    if (next === -1) {
      line = string.slice(position);
      position = length;
    } else {
      line = string.slice(position, next + 1);
      position = next + 1;
    }
    if (line.length && line !== "\n")
      result += ind;
    result += line;
  }
  return result;
}
function generateNextLine(state, level) {
  return "\n" + common.repeat(" ", state.indent * level);
}
function testImplicitResolving(state, str2) {
  var index, length, type2;
  for (index = 0, length = state.implicitTypes.length; index < length; index += 1) {
    type2 = state.implicitTypes[index];
    if (type2.resolve(str2)) {
      return true;
    }
  }
  return false;
}
function isWhitespace(c) {
  return c === CHAR_SPACE || c === CHAR_TAB;
}
function isPrintable(c) {
  return 32 <= c && c <= 126 || 161 <= c && c <= 55295 && c !== 8232 && c !== 8233 || 57344 <= c && c <= 65533 && c !== CHAR_BOM || 65536 <= c && c <= 1114111;
}
function isNsCharOrWhitespace(c) {
  return isPrintable(c) && c !== CHAR_BOM && c !== CHAR_CARRIAGE_RETURN && c !== CHAR_LINE_FEED;
}
function isPlainSafe(c, prev, inblock) {
  var cIsNsCharOrWhitespace = isNsCharOrWhitespace(c);
  var cIsNsChar = cIsNsCharOrWhitespace && !isWhitespace(c);
  return (
    // ns-plain-safe
    (inblock ? (
      // c = flow-in
      cIsNsCharOrWhitespace
    ) : cIsNsCharOrWhitespace && c !== CHAR_COMMA && c !== CHAR_LEFT_SQUARE_BRACKET && c !== CHAR_RIGHT_SQUARE_BRACKET && c !== CHAR_LEFT_CURLY_BRACKET && c !== CHAR_RIGHT_CURLY_BRACKET) && c !== CHAR_SHARP && !(prev === CHAR_COLON && !cIsNsChar) || isNsCharOrWhitespace(prev) && !isWhitespace(prev) && c === CHAR_SHARP || prev === CHAR_COLON && cIsNsChar
  );
}
function isPlainSafeFirst(c) {
  return isPrintable(c) && c !== CHAR_BOM && !isWhitespace(c) && c !== CHAR_MINUS && c !== CHAR_QUESTION && c !== CHAR_COLON && c !== CHAR_COMMA && c !== CHAR_LEFT_SQUARE_BRACKET && c !== CHAR_RIGHT_SQUARE_BRACKET && c !== CHAR_LEFT_CURLY_BRACKET && c !== CHAR_RIGHT_CURLY_BRACKET && c !== CHAR_SHARP && c !== CHAR_AMPERSAND && c !== CHAR_ASTERISK && c !== CHAR_EXCLAMATION && c !== CHAR_VERTICAL_LINE && c !== CHAR_EQUALS && c !== CHAR_GREATER_THAN && c !== CHAR_SINGLE_QUOTE && c !== CHAR_DOUBLE_QUOTE && c !== CHAR_PERCENT && c !== CHAR_COMMERCIAL_AT && c !== CHAR_GRAVE_ACCENT;
}
function isPlainSafeLast(c) {
  return !isWhitespace(c) && c !== CHAR_COLON;
}
function codePointAt(string, pos) {
  var first = string.charCodeAt(pos), second;
  if (first >= 55296 && first <= 56319 && pos + 1 < string.length) {
    second = string.charCodeAt(pos + 1);
    if (second >= 56320 && second <= 57343) {
      return (first - 55296) * 1024 + second - 56320 + 65536;
    }
  }
  return first;
}
function needIndentIndicator(string) {
  var leadingSpaceRe = /^\n* /;
  return leadingSpaceRe.test(string);
}
var STYLE_PLAIN = 1;
var STYLE_SINGLE = 2;
var STYLE_LITERAL = 3;
var STYLE_FOLDED = 4;
var STYLE_DOUBLE = 5;
function chooseScalarStyle(string, singleLineOnly, indentPerLevel, lineWidth, testAmbiguousType, quotingType, forceQuotes, inblock) {
  var i;
  var char = 0;
  var prevChar = null;
  var hasLineBreak = false;
  var hasFoldableLine = false;
  var shouldTrackWidth = lineWidth !== -1;
  var previousLineBreak = -1;
  var plain = isPlainSafeFirst(codePointAt(string, 0)) && isPlainSafeLast(codePointAt(string, string.length - 1));
  if (singleLineOnly || forceQuotes) {
    for (i = 0; i < string.length; char >= 65536 ? i += 2 : i++) {
      char = codePointAt(string, i);
      if (!isPrintable(char)) {
        return STYLE_DOUBLE;
      }
      plain = plain && isPlainSafe(char, prevChar, inblock);
      prevChar = char;
    }
  } else {
    for (i = 0; i < string.length; char >= 65536 ? i += 2 : i++) {
      char = codePointAt(string, i);
      if (char === CHAR_LINE_FEED) {
        hasLineBreak = true;
        if (shouldTrackWidth) {
          hasFoldableLine = hasFoldableLine || // Foldable line = too long, and not more-indented.
          i - previousLineBreak - 1 > lineWidth && string[previousLineBreak + 1] !== " ";
          previousLineBreak = i;
        }
      } else if (!isPrintable(char)) {
        return STYLE_DOUBLE;
      }
      plain = plain && isPlainSafe(char, prevChar, inblock);
      prevChar = char;
    }
    hasFoldableLine = hasFoldableLine || shouldTrackWidth && (i - previousLineBreak - 1 > lineWidth && string[previousLineBreak + 1] !== " ");
  }
  if (!hasLineBreak && !hasFoldableLine) {
    if (plain && !forceQuotes && !testAmbiguousType(string)) {
      return STYLE_PLAIN;
    }
    return quotingType === QUOTING_TYPE_DOUBLE ? STYLE_DOUBLE : STYLE_SINGLE;
  }
  if (indentPerLevel > 9 && needIndentIndicator(string)) {
    return STYLE_DOUBLE;
  }
  if (!forceQuotes) {
    return hasFoldableLine ? STYLE_FOLDED : STYLE_LITERAL;
  }
  return quotingType === QUOTING_TYPE_DOUBLE ? STYLE_DOUBLE : STYLE_SINGLE;
}
function writeScalar(state, string, level, iskey, inblock) {
  state.dump = function() {
    if (string.length === 0) {
      return state.quotingType === QUOTING_TYPE_DOUBLE ? '""' : "''";
    }
    if (!state.noCompatMode) {
      if (DEPRECATED_BOOLEANS_SYNTAX.indexOf(string) !== -1 || DEPRECATED_BASE60_SYNTAX.test(string)) {
        return state.quotingType === QUOTING_TYPE_DOUBLE ? '"' + string + '"' : "'" + string + "'";
      }
    }
    var indent = state.indent * Math.max(1, level);
    var lineWidth = state.lineWidth === -1 ? -1 : Math.max(Math.min(state.lineWidth, 40), state.lineWidth - indent);
    var singleLineOnly = iskey || state.flowLevel > -1 && level >= state.flowLevel;
    function testAmbiguity(string2) {
      return testImplicitResolving(state, string2);
    }
    switch (chooseScalarStyle(
      string,
      singleLineOnly,
      state.indent,
      lineWidth,
      testAmbiguity,
      state.quotingType,
      state.forceQuotes && !iskey,
      inblock
    )) {
      case STYLE_PLAIN:
        return string;
      case STYLE_SINGLE:
        return "'" + string.replace(/'/g, "''") + "'";
      case STYLE_LITERAL:
        return "|" + blockHeader(string, state.indent) + dropEndingNewline(indentString(string, indent));
      case STYLE_FOLDED:
        return ">" + blockHeader(string, state.indent) + dropEndingNewline(indentString(foldString(string, lineWidth), indent));
      case STYLE_DOUBLE:
        return '"' + escapeString(string) + '"';
      default:
        throw new exception("impossible error: invalid scalar style");
    }
  }();
}
function blockHeader(string, indentPerLevel) {
  var indentIndicator = needIndentIndicator(string) ? String(indentPerLevel) : "";
  var clip = string[string.length - 1] === "\n";
  var keep = clip && (string[string.length - 2] === "\n" || string === "\n");
  var chomp = keep ? "+" : clip ? "" : "-";
  return indentIndicator + chomp + "\n";
}
function dropEndingNewline(string) {
  return string[string.length - 1] === "\n" ? string.slice(0, -1) : string;
}
function foldString(string, width) {
  var lineRe = /(\n+)([^\n]*)/g;
  var result = function() {
    var nextLF = string.indexOf("\n");
    nextLF = nextLF !== -1 ? nextLF : string.length;
    lineRe.lastIndex = nextLF;
    return foldLine(string.slice(0, nextLF), width);
  }();
  var prevMoreIndented = string[0] === "\n" || string[0] === " ";
  var moreIndented;
  var match;
  while (match = lineRe.exec(string)) {
    var prefix = match[1], line = match[2];
    moreIndented = line[0] === " ";
    result += prefix + (!prevMoreIndented && !moreIndented && line !== "" ? "\n" : "") + foldLine(line, width);
    prevMoreIndented = moreIndented;
  }
  return result;
}
function foldLine(line, width) {
  if (line === "" || line[0] === " ")
    return line;
  var breakRe = / [^ ]/g;
  var match;
  var start = 0, end, curr = 0, next = 0;
  var result = "";
  while (match = breakRe.exec(line)) {
    next = match.index;
    if (next - start > width) {
      end = curr > start ? curr : next;
      result += "\n" + line.slice(start, end);
      start = end + 1;
    }
    curr = next;
  }
  result += "\n";
  if (line.length - start > width && curr > start) {
    result += line.slice(start, curr) + "\n" + line.slice(curr + 1);
  } else {
    result += line.slice(start);
  }
  return result.slice(1);
}
function escapeString(string) {
  var result = "";
  var char = 0;
  var escapeSeq;
  for (var i = 0; i < string.length; char >= 65536 ? i += 2 : i++) {
    char = codePointAt(string, i);
    escapeSeq = ESCAPE_SEQUENCES[char];
    if (!escapeSeq && isPrintable(char)) {
      result += string[i];
      if (char >= 65536)
        result += string[i + 1];
    } else {
      result += escapeSeq || encodeHex(char);
    }
  }
  return result;
}
function writeFlowSequence(state, level, object) {
  var _result = "", _tag = state.tag, index, length, value;
  for (index = 0, length = object.length; index < length; index += 1) {
    value = object[index];
    if (state.replacer) {
      value = state.replacer.call(object, String(index), value);
    }
    if (writeNode(state, level, value, false, false) || typeof value === "undefined" && writeNode(state, level, null, false, false)) {
      if (_result !== "")
        _result += "," + (!state.condenseFlow ? " " : "");
      _result += state.dump;
    }
  }
  state.tag = _tag;
  state.dump = "[" + _result + "]";
}
function writeBlockSequence(state, level, object, compact) {
  var _result = "", _tag = state.tag, index, length, value;
  for (index = 0, length = object.length; index < length; index += 1) {
    value = object[index];
    if (state.replacer) {
      value = state.replacer.call(object, String(index), value);
    }
    if (writeNode(state, level + 1, value, true, true, false, true) || typeof value === "undefined" && writeNode(state, level + 1, null, true, true, false, true)) {
      if (!compact || _result !== "") {
        _result += generateNextLine(state, level);
      }
      if (state.dump && CHAR_LINE_FEED === state.dump.charCodeAt(0)) {
        _result += "-";
      } else {
        _result += "- ";
      }
      _result += state.dump;
    }
  }
  state.tag = _tag;
  state.dump = _result || "[]";
}
function writeFlowMapping(state, level, object) {
  var _result = "", _tag = state.tag, objectKeyList = Object.keys(object), index, length, objectKey, objectValue, pairBuffer;
  for (index = 0, length = objectKeyList.length; index < length; index += 1) {
    pairBuffer = "";
    if (_result !== "")
      pairBuffer += ", ";
    if (state.condenseFlow)
      pairBuffer += '"';
    objectKey = objectKeyList[index];
    objectValue = object[objectKey];
    if (state.replacer) {
      objectValue = state.replacer.call(object, objectKey, objectValue);
    }
    if (!writeNode(state, level, objectKey, false, false)) {
      continue;
    }
    if (state.dump.length > 1024)
      pairBuffer += "? ";
    pairBuffer += state.dump + (state.condenseFlow ? '"' : "") + ":" + (state.condenseFlow ? "" : " ");
    if (!writeNode(state, level, objectValue, false, false)) {
      continue;
    }
    pairBuffer += state.dump;
    _result += pairBuffer;
  }
  state.tag = _tag;
  state.dump = "{" + _result + "}";
}
function writeBlockMapping(state, level, object, compact) {
  var _result = "", _tag = state.tag, objectKeyList = Object.keys(object), index, length, objectKey, objectValue, explicitPair, pairBuffer;
  if (state.sortKeys === true) {
    objectKeyList.sort();
  } else if (typeof state.sortKeys === "function") {
    objectKeyList.sort(state.sortKeys);
  } else if (state.sortKeys) {
    throw new exception("sortKeys must be a boolean or a function");
  }
  for (index = 0, length = objectKeyList.length; index < length; index += 1) {
    pairBuffer = "";
    if (!compact || _result !== "") {
      pairBuffer += generateNextLine(state, level);
    }
    objectKey = objectKeyList[index];
    objectValue = object[objectKey];
    if (state.replacer) {
      objectValue = state.replacer.call(object, objectKey, objectValue);
    }
    if (!writeNode(state, level + 1, objectKey, true, true, true)) {
      continue;
    }
    explicitPair = state.tag !== null && state.tag !== "?" || state.dump && state.dump.length > 1024;
    if (explicitPair) {
      if (state.dump && CHAR_LINE_FEED === state.dump.charCodeAt(0)) {
        pairBuffer += "?";
      } else {
        pairBuffer += "? ";
      }
    }
    pairBuffer += state.dump;
    if (explicitPair) {
      pairBuffer += generateNextLine(state, level);
    }
    if (!writeNode(state, level + 1, objectValue, true, explicitPair)) {
      continue;
    }
    if (state.dump && CHAR_LINE_FEED === state.dump.charCodeAt(0)) {
      pairBuffer += ":";
    } else {
      pairBuffer += ": ";
    }
    pairBuffer += state.dump;
    _result += pairBuffer;
  }
  state.tag = _tag;
  state.dump = _result || "{}";
}
function detectType(state, object, explicit) {
  var _result, typeList, index, length, type2, style;
  typeList = explicit ? state.explicitTypes : state.implicitTypes;
  for (index = 0, length = typeList.length; index < length; index += 1) {
    type2 = typeList[index];
    if ((type2.instanceOf || type2.predicate) && (!type2.instanceOf || typeof object === "object" && object instanceof type2.instanceOf) && (!type2.predicate || type2.predicate(object))) {
      if (explicit) {
        if (type2.multi && type2.representName) {
          state.tag = type2.representName(object);
        } else {
          state.tag = type2.tag;
        }
      } else {
        state.tag = "?";
      }
      if (type2.represent) {
        style = state.styleMap[type2.tag] || type2.defaultStyle;
        if (_toString.call(type2.represent) === "[object Function]") {
          _result = type2.represent(object, style);
        } else if (_hasOwnProperty.call(type2.represent, style)) {
          _result = type2.represent[style](object, style);
        } else {
          throw new exception("!<" + type2.tag + '> tag resolver accepts not "' + style + '" style');
        }
        state.dump = _result;
      }
      return true;
    }
  }
  return false;
}
function writeNode(state, level, object, block, compact, iskey, isblockseq) {
  state.tag = null;
  state.dump = object;
  if (!detectType(state, object, false)) {
    detectType(state, object, true);
  }
  var type2 = _toString.call(state.dump);
  var inblock = block;
  var tagStr;
  if (block) {
    block = state.flowLevel < 0 || state.flowLevel > level;
  }
  var objectOrArray = type2 === "[object Object]" || type2 === "[object Array]", duplicateIndex, duplicate;
  if (objectOrArray) {
    duplicateIndex = state.duplicates.indexOf(object);
    duplicate = duplicateIndex !== -1;
  }
  if (state.tag !== null && state.tag !== "?" || duplicate || state.indent !== 2 && level > 0) {
    compact = false;
  }
  if (duplicate && state.usedDuplicates[duplicateIndex]) {
    state.dump = "*ref_" + duplicateIndex;
  } else {
    if (objectOrArray && duplicate && !state.usedDuplicates[duplicateIndex]) {
      state.usedDuplicates[duplicateIndex] = true;
    }
    if (type2 === "[object Object]") {
      if (block && Object.keys(state.dump).length !== 0) {
        writeBlockMapping(state, level, state.dump, compact);
        if (duplicate) {
          state.dump = "&ref_" + duplicateIndex + state.dump;
        }
      } else {
        writeFlowMapping(state, level, state.dump);
        if (duplicate) {
          state.dump = "&ref_" + duplicateIndex + " " + state.dump;
        }
      }
    } else if (type2 === "[object Array]") {
      if (block && state.dump.length !== 0) {
        if (state.noArrayIndent && !isblockseq && level > 0) {
          writeBlockSequence(state, level - 1, state.dump, compact);
        } else {
          writeBlockSequence(state, level, state.dump, compact);
        }
        if (duplicate) {
          state.dump = "&ref_" + duplicateIndex + state.dump;
        }
      } else {
        writeFlowSequence(state, level, state.dump);
        if (duplicate) {
          state.dump = "&ref_" + duplicateIndex + " " + state.dump;
        }
      }
    } else if (type2 === "[object String]") {
      if (state.tag !== "?") {
        writeScalar(state, state.dump, level, iskey, inblock);
      }
    } else if (type2 === "[object Undefined]") {
      return false;
    } else {
      if (state.skipInvalid)
        return false;
      throw new exception("unacceptable kind of an object to dump " + type2);
    }
    if (state.tag !== null && state.tag !== "?") {
      tagStr = encodeURI(
        state.tag[0] === "!" ? state.tag.slice(1) : state.tag
      ).replace(/!/g, "%21");
      if (state.tag[0] === "!") {
        tagStr = "!" + tagStr;
      } else if (tagStr.slice(0, 18) === "tag:yaml.org,2002:") {
        tagStr = "!!" + tagStr.slice(18);
      } else {
        tagStr = "!<" + tagStr + ">";
      }
      state.dump = tagStr + " " + state.dump;
    }
  }
  return true;
}
function getDuplicateReferences(object, state) {
  var objects = [], duplicatesIndexes = [], index, length;
  inspectNode(object, objects, duplicatesIndexes);
  for (index = 0, length = duplicatesIndexes.length; index < length; index += 1) {
    state.duplicates.push(objects[duplicatesIndexes[index]]);
  }
  state.usedDuplicates = new Array(length);
}
function inspectNode(object, objects, duplicatesIndexes) {
  var objectKeyList, index, length;
  if (object !== null && typeof object === "object") {
    index = objects.indexOf(object);
    if (index !== -1) {
      if (duplicatesIndexes.indexOf(index) === -1) {
        duplicatesIndexes.push(index);
      }
    } else {
      objects.push(object);
      if (Array.isArray(object)) {
        for (index = 0, length = object.length; index < length; index += 1) {
          inspectNode(object[index], objects, duplicatesIndexes);
        }
      } else {
        objectKeyList = Object.keys(object);
        for (index = 0, length = objectKeyList.length; index < length; index += 1) {
          inspectNode(object[objectKeyList[index]], objects, duplicatesIndexes);
        }
      }
    }
  }
}
function dump$1(input, options) {
  options = options || {};
  var state = new State(options);
  if (!state.noRefs)
    getDuplicateReferences(input, state);
  var value = input;
  if (state.replacer) {
    value = state.replacer.call({ "": value }, "", value);
  }
  if (writeNode(state, 0, value, true, true))
    return state.dump + "\n";
  return "";
}
var dump_1 = dump$1;
var dumper = {
  dump: dump_1
};
function renamed(from, to) {
  return function() {
    throw new Error("Function yaml." + from + " is removed in js-yaml 4. Use yaml." + to + " instead, which is now safe by default.");
  };
}
var load = loader.load;
var loadAll = loader.loadAll;
var dump = dumper.dump;
var safeLoad = renamed("safeLoad", "load");
var safeLoadAll = renamed("safeLoadAll", "loadAll");
var safeDump = renamed("safeDump", "dump");

// src/ElysiumExporter.ts
function getFs() {
  var _a;
  return (_a = window.require) == null ? void 0 : _a.call(window, "fs");
}
var ElysiumExporter = class {
  constructor(pluginVersion = "1.0.0") {
    this.pluginVersion = pluginVersion;
    this.exporter = new OpenTimeExporter(pluginVersion);
  }
  /**
   * Generate a sanitized filename for Elysium import
   * Format: elysium-[type]-[sanitized-title].ot
   * Must start with "elysium-" for Elysium's auto-import to detect it
   */
  sanitizedFilename(title, type2) {
    let sanitized = title.toLowerCase().trim();
    sanitized = sanitized.replace(/[\s_]+/g, "-");
    sanitized = sanitized.replace(/[^a-z0-9-]/g, "");
    sanitized = sanitized.replace(/-+/g, "-");
    sanitized = sanitized.replace(/^-+|-+$/g, "");
    if (sanitized.length > 50) {
      sanitized = sanitized.substring(0, 50).replace(/-+$/, "");
    }
    if (!sanitized) {
      sanitized = "untitled";
    }
    return `elysium-${type2.toLowerCase()}-${sanitized}.ot`;
  }
  /**
   * Export items based on Elysium's export mode preference
   * - Single File mode: merge into elysium-schedule.ot
   * - Per Item mode: create individual files
   */
  async exportItems(items, elysiumFolderPath, timezone) {
    if (!elysiumFolderPath) {
      new import_obsidian.Notice("Export folder not configured. Please set it in plugin settings.");
      return false;
    }
    const prefs = await readElysiumPreferences();
    if (prefs.exportMode === "per-item") {
      return Promise.resolve(this.exportPerItem(items, elysiumFolderPath, timezone));
    } else {
      return Promise.resolve(this.exportSingleFile(items, elysiumFolderPath, timezone, prefs.singleFilename));
    }
  }
  /**
   * Single File mode: Merge items into existing file by ID
   * Updates existing items, adds new ones
   */
  exportSingleFile(items, elysiumFolderPath, timezone, filename) {
    const fs = getFs();
    if (!fs) {
      new import_obsidian.Notice("File system not available");
      return false;
    }
    const normalizedPath = elysiumFolderPath.replace(/\/$/, "");
    const fullPath = `${normalizedPath}/${filename}.ot`;
    try {
      if (!fs.existsSync(normalizedPath)) {
        fs.mkdirSync(normalizedPath, { recursive: true });
      }
      let existingItems = [];
      if (fs.existsSync(fullPath)) {
        try {
          const content = fs.readFileSync(fullPath, "utf8");
          const existingDoc = load(content);
          if (existingDoc && existingDoc.items) {
            existingItems = existingDoc.items;
          }
        } catch (parseError) {
          console.warn("[OpenTime] Failed to parse existing file, will overwrite:", parseError);
        }
      }
      const itemMap = /* @__PURE__ */ new Map();
      for (const item of existingItems) {
        itemMap.set(item.id, item);
      }
      for (const item of items) {
        itemMap.set(item.id, item);
      }
      const document = {
        opentime_version: "0.2",
        default_timezone: timezone,
        generated_by: `Obsidian OpenTime Export ${this.pluginVersion}`,
        created_at: new Date().toISOString(),
        items: Array.from(itemMap.values())
      };
      const yamlContent = this.exporter.export(document);
      fs.writeFileSync(fullPath, yamlContent, "utf8");
      new import_obsidian.Notice(`Exported ${items.length} items to ${filename}.ot`);
      return true;
    } catch (error) {
      console.error("[OpenTime] Failed to export single file:", error);
      const message = error instanceof Error ? error.message : "Unknown error";
      new import_obsidian.Notice(`Failed to export: ${message}`);
      return false;
    }
  }
  /**
   * Per Item mode: Create individual files for each item
   */
  exportPerItem(items, elysiumFolderPath, timezone) {
    let successCount = 0;
    for (const item of items) {
      const success = this.exportItem(item, elysiumFolderPath, timezone);
      if (success)
        successCount++;
    }
    if (successCount === items.length) {
      new import_obsidian.Notice(`Exported ${successCount} items`);
      return true;
    } else if (successCount > 0) {
      new import_obsidian.Notice(`Exported ${successCount}/${items.length} items (some failed)`);
      return true;
    } else {
      new import_obsidian.Notice("Failed to export items");
      return false;
    }
  }
  /**
   * Export a single item to Elysium's OpenTime folder
   * Creates an .ot file with Elysium-compatible naming
   */
  exportItem(item, elysiumFolderPath, timezone) {
    const document = {
      opentime_version: "0.2",
      default_timezone: timezone,
      generated_by: `Obsidian OpenTime Export ${this.pluginVersion}`,
      created_at: new Date().toISOString(),
      items: [item]
    };
    const filename = this.sanitizedFilename(item.title, item.type);
    return this.exportDocument(document, elysiumFolderPath, filename);
  }
  /**
   * Export a full document to Elysium's OpenTime folder
   */
  exportDocument(document, elysiumFolderPath, filename) {
    try {
      if (!elysiumFolderPath) {
        new import_obsidian.Notice("Export folder not configured. Please set it in plugin settings.");
        return false;
      }
      const normalizedPath = elysiumFolderPath.replace(/\/$/, "");
      const fullPath = `${normalizedPath}/${filename}`;
      const yamlContent = this.exporter.export(document);
      const fs = getFs();
      if (!fs) {
        new import_obsidian.Notice("File system not available");
        return false;
      }
      if (!fs.existsSync(normalizedPath)) {
        fs.mkdirSync(normalizedPath, { recursive: true });
      }
      fs.writeFileSync(fullPath, yamlContent, "utf8");
      return true;
    } catch (error) {
      console.error("[OpenTime] Failed to export to Elysium folder:", error);
      const message = error instanceof Error ? error.message : "Unknown error";
      new import_obsidian.Notice(`Failed to export: ${message}`);
      return false;
    }
  }
  /**
   * Check if the Elysium folder is accessible
   */
  checkFolderAccess(elysiumFolderPath) {
    try {
      const fs = getFs();
      if (!fs)
        return false;
      if (!elysiumFolderPath) {
        return false;
      }
      if (fs.existsSync(elysiumFolderPath)) {
        fs.accessSync(elysiumFolderPath, fs.constants.W_OK);
        return true;
      }
      fs.mkdirSync(elysiumFolderPath, { recursive: true });
      return true;
    } catch (e) {
      return false;
    }
  }
};

// src/modals/CreateItemModal.ts
var CreateItemModal = class extends import_obsidian2.Modal {
  constructor(app, settings, pluginVersion, initialType = null, initialText = "") {
    super(app);
    // Form fields
    this.itemType = "task";
    this.title = "";
    // Task fields
    this.dueDate = "";
    this.scheduledStart = "";
    this.priority = 0;
    // Event/Appointment fields
    this.startDate = "";
    this.startTime = "";
    this.endDate = "";
    this.endTime = "";
    this.location = "";
    this.attendees = "";
    // Goal/Project fields
    this.targetDate = "";
    // Habit fields
    this.habitFrequency = "daily";
    this.habitDays = [];
    this.windowStart = "";
    this.windowEnd = "";
    // Reminder fields
    this.reminderTime = "";
    this.reminderDate = "";
    // Common fields
    this.notes = "";
    this.tags = "";
    this.categories = "";
    this.estimateMinutes = 0;
    this.steps = [];
    // Recurrence fields
    this.repeatsEnabled = false;
    this.repeatsCount = 1;
    this.repeatsPer = "Day";
    this.repeatsWeekdays = [];
    this.repeatsEndType = "Never";
    this.repeatsEndCount = 10;
    this.repeatsEndDate = "";
    this.settings = settings;
    this.elysiumExporter = new ElysiumExporter(pluginVersion);
    this.openTimeExporter = new OpenTimeExporter(pluginVersion);
    this.initialType = initialType;
    this.initialText = initialText;
    this.insertIntoNote = settings.insertMarkdownByDefault;
    const activeView = this.app.workspace.getActiveViewOfType(import_obsidian2.MarkdownView);
    this.currentFile = (activeView == null ? void 0 : activeView.file) || null;
    if (initialType) {
      this.itemType = initialType;
    }
    if (initialText) {
      this.title = initialText.trim();
    }
    const today = formatDate(new Date());
    this.dueDate = today;
    this.startDate = today;
    this.endDate = today;
    this.targetDate = today;
    this.reminderDate = today;
  }
  onOpen() {
    const { contentEl } = this;
    this.contentEl = contentEl;
    contentEl.empty();
    contentEl.addClass("opentime-create-modal");
    new import_obsidian2.Setting(contentEl).setName("Create new item").setHeading();
    this.buildForm();
  }
  buildForm() {
    const { contentEl } = this;
    const existingForm = contentEl.querySelector(".opentime-form");
    if (existingForm) {
      existingForm.remove();
    }
    const formContainer = contentEl.createDiv({ cls: "opentime-form" });
    if (!this.initialType) {
      new import_obsidian2.Setting(formContainer).setName("Type").setDesc("What kind of item are you creating?").addDropdown((dropdown) => {
        dropdown.addOption("goal", "goal").addOption("task", "task").addOption("habit", "habit").addOption("reminder", "reminder").addOption("event", "event").addOption("appointment", "appointment").addOption("project", "project").setValue(this.itemType).onChange((value) => {
          this.itemType = value;
          this.buildForm();
        });
      });
    } else {
      formContainer.createEl("p", {
        text: `Creating: ${this.initialType}`,
        cls: "opentime-type-label"
      });
    }
    new import_obsidian2.Setting(formContainer).setName("Title").setDesc("Name of the item").addText((text) => {
      text.setPlaceholder("Enter title...").setValue(this.title).onChange((value) => {
        this.title = value;
      });
      text.inputEl.addClass("opentime-title-input");
    });
    this.buildTypeSpecificFields(formContainer);
    this.buildCommonFields(formContainer);
    new import_obsidian2.Setting(formContainer).setName("Insert into note").setDesc("Also add markdown to the current note").addToggle((toggle) => {
      toggle.setValue(this.insertIntoNote).onChange((value) => {
        this.insertIntoNote = value;
      });
    });
    const buttonContainer = formContainer.createDiv({ cls: "opentime-buttons" });
    const cancelBtn = buttonContainer.createEl("button", { text: "cancel" });
    cancelBtn.addEventListener("click", () => this.close());
    const createBtn = buttonContainer.createEl("button", {
      text: "create",
      cls: "mod-cta"
    });
    createBtn.addEventListener("click", () => this.handleSubmit());
  }
  buildTypeSpecificFields(container) {
    switch (this.itemType) {
      case "goal":
        this.buildGoalFields(container);
        break;
      case "task":
        this.buildTaskFields(container);
        break;
      case "habit":
        this.buildHabitFields(container);
        break;
      case "reminder":
        this.buildReminderFields(container);
        break;
      case "event":
        this.buildEventFields(container);
        break;
      case "appointment":
        this.buildAppointmentFields(container);
        break;
      case "project":
        this.buildProjectFields(container);
        break;
    }
  }
  buildGoalFields(container) {
    new import_obsidian2.Setting(container).setName("Target date").setDesc("When do you want to achieve this goal?").addText((text) => {
      text.setPlaceholder("YYYY-MM-DD").setValue(this.targetDate).onChange((value) => {
        this.targetDate = value;
      });
      text.inputEl.type = "date";
    });
    new import_obsidian2.Setting(container).setName("Duration (minutes)").setDesc("Estimated time to complete").addText((text) => {
      text.setPlaceholder("60").setValue(this.estimateMinutes > 0 ? String(this.estimateMinutes) : "").onChange((value) => {
        this.estimateMinutes = parseInt(value) || 0;
      });
      text.inputEl.type = "number";
      text.inputEl.min = "0";
    });
  }
  buildTaskFields(container) {
    new import_obsidian2.Setting(container).setName("Due date").setDesc("When is this task due?").addText((text) => {
      text.setPlaceholder("YYYY-MM-DD").setValue(this.dueDate).onChange((value) => {
        this.dueDate = value;
      });
      text.inputEl.type = "date";
    });
    new import_obsidian2.Setting(container).setName("Scheduled start").setDesc("When do you plan to work on this?").addText((text) => {
      text.setPlaceholder("YYYY-MM-DD").setValue(this.scheduledStart).onChange((value) => {
        this.scheduledStart = value;
      });
      text.inputEl.type = "date";
    });
    new import_obsidian2.Setting(container).setName("Priority").setDesc("0 = none, 1-3 = low, 4-6 = medium, 7-10 = high").addSlider((slider) => {
      slider.setLimits(0, 10, 1).setValue(this.priority).setDynamicTooltip().onChange((value) => {
        this.priority = value;
      });
    });
    new import_obsidian2.Setting(container).setName("Duration (minutes)").setDesc("Estimated time to complete").addText((text) => {
      text.setPlaceholder("30").setValue(this.estimateMinutes > 0 ? String(this.estimateMinutes) : "").onChange((value) => {
        this.estimateMinutes = parseInt(value) || 0;
      });
      text.inputEl.type = "number";
      text.inputEl.min = "0";
    });
  }
  buildHabitFields(container) {
    new import_obsidian2.Setting(container).setName("Frequency").setDesc("How often should this habit occur?").addDropdown((dropdown) => {
      dropdown.addOption("daily", "daily").addOption("weekly", "weekly").addOption("custom", "custom days").setValue(this.habitFrequency).onChange((value) => {
        this.habitFrequency = value;
      });
    });
    new import_obsidian2.Setting(container).setName("Window start").setDesc("Earliest time to do this habit").addText((text) => {
      text.setPlaceholder("HH:MM").setValue(this.windowStart).onChange((value) => {
        this.windowStart = value;
      });
      text.inputEl.type = "time";
    });
    new import_obsidian2.Setting(container).setName("Window end").setDesc("Latest time to do this habit").addText((text) => {
      text.setPlaceholder("HH:MM").setValue(this.windowEnd).onChange((value) => {
        this.windowEnd = value;
      });
      text.inputEl.type = "time";
    });
    new import_obsidian2.Setting(container).setName("Duration (minutes)").setDesc("How long does this habit take?").addText((text) => {
      text.setPlaceholder("15").setValue(this.estimateMinutes > 0 ? String(this.estimateMinutes) : "").onChange((value) => {
        this.estimateMinutes = parseInt(value) || 0;
      });
      text.inputEl.type = "number";
      text.inputEl.min = "0";
    });
  }
  buildReminderFields(container) {
    new import_obsidian2.Setting(container).setName("Reminder date").setDesc("What date to remind you").addText((text) => {
      text.setPlaceholder("YYYY-MM-DD").setValue(this.reminderDate).onChange((value) => {
        this.reminderDate = value;
      });
      text.inputEl.type = "date";
    });
    new import_obsidian2.Setting(container).setName("Reminder time").setDesc("What time to remind you").addText((text) => {
      text.setPlaceholder("HH:MM").setValue(this.reminderTime).onChange((value) => {
        this.reminderTime = value;
      });
      text.inputEl.type = "time";
    });
  }
  buildEventFields(container) {
    new import_obsidian2.Setting(container).setName("Start date").addText((text) => {
      text.setValue(this.startDate).onChange((value) => {
        this.startDate = value;
      });
      text.inputEl.type = "date";
    });
    new import_obsidian2.Setting(container).setName("Start time").addText((text) => {
      text.setPlaceholder("HH:MM").setValue(this.startTime).onChange((value) => {
        this.startTime = value;
      });
      text.inputEl.type = "time";
    });
    new import_obsidian2.Setting(container).setName("End date").addText((text) => {
      text.setValue(this.endDate).onChange((value) => {
        this.endDate = value;
      });
      text.inputEl.type = "date";
    });
    new import_obsidian2.Setting(container).setName("End time").addText((text) => {
      text.setPlaceholder("HH:MM").setValue(this.endTime).onChange((value) => {
        this.endTime = value;
      });
      text.inputEl.type = "time";
    });
    new import_obsidian2.Setting(container).setName("Location").addText((text) => {
      text.setPlaceholder("Where is this event?").setValue(this.location).onChange((value) => {
        this.location = value;
      });
    });
  }
  buildAppointmentFields(container) {
    this.buildEventFields(container);
    new import_obsidian2.Setting(container).setName("Attendees").setDesc("Comma-separated list of attendees").addText((text) => {
      text.setPlaceholder("alice, bob, carol").setValue(this.attendees).onChange((value) => {
        this.attendees = value;
      });
    });
  }
  buildProjectFields(container) {
    new import_obsidian2.Setting(container).setName("Target date").setDesc("When should this project be completed?").addText((text) => {
      text.setPlaceholder("YYYY-MM-DD").setValue(this.targetDate).onChange((value) => {
        this.targetDate = value;
      });
      text.inputEl.type = "date";
    });
    new import_obsidian2.Setting(container).setName("Duration (minutes)").setDesc("Estimated total time for project").addText((text) => {
      text.setPlaceholder("120").setValue(this.estimateMinutes > 0 ? String(this.estimateMinutes) : "").onChange((value) => {
        this.estimateMinutes = parseInt(value) || 0;
      });
      text.inputEl.type = "number";
      text.inputEl.min = "0";
    });
  }
  buildCommonFields(container) {
    new import_obsidian2.Setting(container).setName("Categories").setDesc("Comma-separated categories (labels)").addText((text) => {
      text.setPlaceholder("personal, health, work").setValue(this.categories).onChange((value) => {
        this.categories = value;
      });
    });
    new import_obsidian2.Setting(container).setName("Tags").setDesc("Comma-separated tags").addText((text) => {
      text.setPlaceholder("important, urgent, review").setValue(this.tags).onChange((value) => {
        this.tags = value;
      });
    });
    if (["goal", "task", "project"].includes(this.itemType)) {
      this.buildStepsSection(container);
    }
    if (["goal", "task", "habit"].includes(this.itemType)) {
      this.buildRecurrenceSection(container);
    }
    new import_obsidian2.Setting(container).setName("Notes").setDesc("Additional notes").addTextArea((textarea) => {
      textarea.setPlaceholder("Any additional details...").setValue(this.notes).onChange((value) => {
        this.notes = value;
      });
      textarea.inputEl.rows = 3;
    });
  }
  buildStepsSection(container) {
    const stepsContainer = container.createDiv({ cls: "opentime-steps-section" });
    new import_obsidian2.Setting(stepsContainer).setName("Steps (checklist)").setHeading();
    const stepsList = stepsContainer.createDiv({ cls: "opentime-steps-list" });
    this.renderSteps(stepsList);
    new import_obsidian2.Setting(stepsContainer).setName("Add step").addText((text) => {
      text.setPlaceholder("Step title...");
      text.inputEl.id = "new-step-input";
    }).addButton((button) => {
      button.setButtonText("+").onClick(() => {
        const input = stepsContainer.querySelector("#new-step-input");
        if (input && input.value.trim()) {
          this.steps.push({
            id: `step_${Date.now()}`,
            title: input.value.trim(),
            completed: false,
            order: this.steps.length,
            status: "pending"
          });
          input.value = "";
          this.renderSteps(stepsList);
        }
      });
    });
  }
  renderSteps(container) {
    container.empty();
    this.steps.forEach((step, index) => {
      const stepEl = container.createDiv({ cls: "opentime-step-item" });
      stepEl.createSpan({ text: `${index + 1}. ${step.title}`, cls: "opentime-step-title" });
      const removeBtn = stepEl.createEl("button", { text: "\xD7", cls: "opentime-step-remove" });
      removeBtn.addEventListener("click", () => {
        this.steps = this.steps.filter((s) => s.id !== step.id);
        this.renderSteps(container);
      });
    });
  }
  buildRecurrenceSection(container) {
    const recurrenceContainer = container.createDiv({ cls: "opentime-recurrence-section" });
    new import_obsidian2.Setting(recurrenceContainer).setName("Repeats").setDesc("Make this a recurring item").addToggle((toggle) => {
      toggle.setValue(this.repeatsEnabled).onChange((value) => {
        this.repeatsEnabled = value;
        const options = recurrenceContainer.querySelector(".opentime-recurrence-options");
        if (options) {
          options.toggleClass("opentime-recurrence-hidden", !value);
        }
      });
    });
    const optionsContainerCls = this.repeatsEnabled ? "opentime-recurrence-options" : "opentime-recurrence-options opentime-recurrence-hidden";
    const optionsContainer = recurrenceContainer.createDiv({ cls: optionsContainerCls });
    new import_obsidian2.Setting(optionsContainer).setName("Repeat").setDesc("How often to repeat").addText((text) => {
      text.setPlaceholder("1").setValue(String(this.repeatsCount)).onChange((value) => {
        this.repeatsCount = parseInt(value) || 1;
      });
      text.inputEl.type = "number";
      text.inputEl.min = "1";
      text.inputEl.addClass("opentime-narrow-input");
    }).addDropdown((dropdown) => {
      dropdown.addOption("Day", "day(s)").addOption("Week", "week(s)").addOption("Month", "month(s)").addOption("Year", "year(s)").setValue(this.repeatsPer).onChange((value) => {
        this.repeatsPer = value;
        const weekdaySec = optionsContainer.querySelector(".opentime-weekday-section");
        if (weekdaySec) {
          weekdaySec.toggleClass("opentime-weekday-hidden", value !== "Week");
        }
      });
    });
    const weekdayCls = this.repeatsPer === "Week" ? "opentime-weekday-section" : "opentime-weekday-section opentime-weekday-hidden";
    const weekdaySection = optionsContainer.createDiv({ cls: weekdayCls });
    new import_obsidian2.Setting(weekdaySection).setName("On days").setDesc("Select days of the week");
    const weekdayButtons = weekdaySection.createDiv({ cls: "opentime-weekday-buttons" });
    const weekdays = ["sun", "mon", "tue", "wed", "thu", "fri", "sat"];
    weekdays.forEach((day) => {
      const btn = weekdayButtons.createEl("button", {
        text: day,
        cls: this.repeatsWeekdays.includes(day) ? "opentime-weekday-btn active" : "opentime-weekday-btn"
      });
      btn.addEventListener("click", (e) => {
        e.preventDefault();
        if (this.repeatsWeekdays.includes(day)) {
          this.repeatsWeekdays = this.repeatsWeekdays.filter((d) => d !== day);
          btn.removeClass("active");
        } else {
          this.repeatsWeekdays.push(day);
          btn.addClass("active");
        }
      });
    });
    new import_obsidian2.Setting(optionsContainer).setName("Ends").addDropdown((dropdown) => {
      dropdown.addOption("Never", "never").addOption("After", "after X occurrences").addOption("On Date", "on specific date").setValue(this.repeatsEndType).onChange((value) => {
        this.repeatsEndType = value;
        const afterSec = optionsContainer.querySelector(".opentime-end-after");
        const dateSec = optionsContainer.querySelector(".opentime-end-date");
        if (afterSec)
          afterSec.toggleClass("opentime-end-hidden", value !== "After");
        if (dateSec)
          dateSec.toggleClass("opentime-end-hidden", value !== "On Date");
      });
    });
    const afterCls = this.repeatsEndType === "After" ? "opentime-end-after" : "opentime-end-after opentime-end-hidden";
    const afterSection = optionsContainer.createDiv({ cls: afterCls });
    new import_obsidian2.Setting(afterSection).setName("Occurrences").addText((text) => {
      text.setPlaceholder("10").setValue(String(this.repeatsEndCount)).onChange((value) => {
        this.repeatsEndCount = parseInt(value) || 10;
      });
      text.inputEl.type = "number";
      text.inputEl.min = "1";
    });
    const dateCls = this.repeatsEndType === "On Date" ? "opentime-end-date" : "opentime-end-date opentime-end-hidden";
    const dateSection = optionsContainer.createDiv({ cls: dateCls });
    new import_obsidian2.Setting(dateSection).setName("End date").addText((text) => {
      text.setValue(this.repeatsEndDate).onChange((value) => {
        this.repeatsEndDate = value;
      });
      text.inputEl.type = "date";
    });
  }
  handleSubmit() {
    if (!this.title.trim()) {
      new import_obsidian2.Notice("Please enter a title");
      return;
    }
    const item = this.buildItem();
    if (!item) {
      return;
    }
    if (!this.settings.elysiumFolderPath) {
      new import_obsidian2.Notice("Export folder not configured. Please set it in plugin settings.");
      return;
    }
    const success = this.elysiumExporter.exportItem(
      item,
      this.settings.elysiumFolderPath,
      this.settings.defaultTimezone
    );
    if (!success) {
      return;
    }
    if (this.insertIntoNote && this.currentFile) {
      this.insertMarkdown(item);
    }
    this.close();
  }
  buildItem() {
    var _a, _b, _c;
    const id = generateId(this.settings.idPrefix + "_" + this.itemType, this.title);
    const parsedTags = this.tags.split(",").map((t) => t.trim()).filter((t) => t.length > 0);
    const parsedCategories = this.categories.split(",").map((c) => c.trim()).filter((c) => c.length > 0);
    const folderPath = ((_b = (_a = this.currentFile) == null ? void 0 : _a.parent) == null ? void 0 : _b.path) || "";
    const repeats = this.repeatsEnabled ? {
      enabled: true,
      count: this.repeatsCount,
      per: this.repeatsPer,
      weekdays: this.repeatsPer === "Week" && this.repeatsWeekdays.length > 0 ? this.repeatsWeekdays : void 0,
      end_type: this.repeatsEndType,
      end_count: this.repeatsEndType === "After" ? this.repeatsEndCount : void 0,
      end_date: this.repeatsEndType === "On Date" ? this.repeatsEndDate : void 0
    } : void 0;
    const baseProps = {
      id,
      title: this.title.trim(),
      tags: parsedTags.length > 0 ? parsedTags : void 0,
      categories: parsedCategories.length > 0 ? parsedCategories : void 0,
      notes: this.notes.trim() || void 0,
      steps: this.steps.length > 0 ? this.steps : void 0,
      x_obsidian: {
        source_file: ((_c = this.currentFile) == null ? void 0 : _c.path) || "unknown",
        folder_path: folderPath || void 0
      }
    };
    switch (this.itemType) {
      case "goal": {
        const goalItem = {
          type: "goal",
          kind: "goal",
          target_date: this.targetDate || void 0,
          progress: 0,
          estimate_minutes: this.estimateMinutes > 0 ? this.estimateMinutes : void 0,
          repeats,
          ...baseProps
        };
        return goalItem;
      }
      case "task": {
        const taskItem = {
          type: "task",
          status: "todo",
          due: this.dueDate || void 0,
          scheduled_start: this.scheduledStart ? `${this.scheduledStart}T09:00:00` : void 0,
          priority: this.priority > 0 ? this.priority : void 0,
          estimate_minutes: this.estimateMinutes > 0 ? this.estimateMinutes : void 0,
          repeats,
          ...baseProps
        };
        return taskItem;
      }
      case "habit": {
        const habitItem = {
          type: "habit",
          pattern: {
            freq: this.habitFrequency
          },
          window: this.windowStart || this.windowEnd ? {
            start_time: this.windowStart || void 0,
            end_time: this.windowEnd || void 0
          } : void 0,
          streak: { current: 0, longest: 0 },
          estimate_minutes: this.estimateMinutes > 0 ? this.estimateMinutes : void 0,
          repeats,
          ...baseProps
        };
        return habitItem;
      }
      case "reminder": {
        if (!this.reminderDate || !this.reminderTime) {
          new import_obsidian2.Notice("Please set reminder date and time");
          return null;
        }
        const reminderItem = {
          type: "reminder",
          time: `${this.reminderDate}T${this.reminderTime}:00`,
          ...baseProps
        };
        return reminderItem;
      }
      case "event": {
        if (!this.startDate || !this.startTime) {
          new import_obsidian2.Notice("Please set start date and time");
          return null;
        }
        const eventItem = {
          type: "event",
          start: `${this.startDate}T${this.startTime}:00`,
          end: `${this.endDate || this.startDate}T${this.endTime || this.startTime}:00`,
          timezone: this.settings.defaultTimezone,
          location: this.location || void 0,
          ...baseProps
        };
        return eventItem;
      }
      case "appointment": {
        if (!this.startDate || !this.startTime) {
          new import_obsidian2.Notice("Please set start date and time");
          return null;
        }
        const attendeesList = this.attendees.split(",").map((a) => a.trim()).filter((a) => a.length > 0);
        const appointmentItem = {
          type: "appointment",
          start: `${this.startDate}T${this.startTime}:00`,
          end: `${this.endDate || this.startDate}T${this.endTime || this.startTime}:00`,
          attendees: attendeesList,
          location: this.location || void 0,
          ...baseProps
        };
        return appointmentItem;
      }
      case "project": {
        const projectItem = {
          type: "project",
          kind: "project",
          target_date: this.targetDate || void 0,
          progress: 0,
          children: [],
          estimate_minutes: this.estimateMinutes > 0 ? this.estimateMinutes : void 0,
          ...baseProps
        };
        return projectItem;
      }
      default: {
        return null;
      }
    }
  }
  insertMarkdown(item) {
    const activeView = this.app.workspace.getActiveViewOfType(import_obsidian2.MarkdownView);
    if (!activeView || !activeView.editor) {
      return;
    }
    const editor = activeView.editor;
    const cursor = editor.getCursor();
    const markdown = this.generateMarkdown(item);
    editor.replaceRange(markdown + "\n", cursor);
  }
  generateMarkdown(item) {
    var _a, _b, _c, _d, _e;
    switch (item.type) {
      case "goal": {
        return `## goal: ${item.title}${item.target_date ? ` (target: ${item.target_date})` : ""}`;
      }
      case "task": {
        let taskMd = `- [ ] ${item.title}`;
        if (item.due)
          taskMd += ` \u{1F4C5} ${item.due}`;
        if (item.scheduled_start)
          taskMd += ` \u23F3 ${item.scheduled_start.split("T")[0]}`;
        return taskMd;
      }
      case "habit": {
        return `- [ ] ${item.title} \u{1F501} ${((_a = item.pattern) == null ? void 0 : _a.freq) || "daily"}`;
      }
      case "reminder": {
        const reminderDateTime = item.time.replace("T", " @ ").slice(0, -3);
        return `- \u23F0 ${item.title} @ ${reminderDateTime}`;
      }
      case "event": {
        const startTime = ((_b = item.start.split("T")[1]) == null ? void 0 : _b.slice(0, 5)) || "";
        const endTime = ((_c = item.end.split("T")[1]) == null ? void 0 : _c.slice(0, 5)) || "";
        return `- ${startTime} - ${endTime} ${item.title}${item.location ? ` (${item.location})` : ""}`;
      }
      case "appointment": {
        const apptStart = ((_d = item.start.split("T")[1]) == null ? void 0 : _d.slice(0, 5)) || "";
        const apptEnd = ((_e = item.end.split("T")[1]) == null ? void 0 : _e.slice(0, 5)) || "";
        const attendeesStr = item.attendees.length > 0 ? ` \u{1F465} ${item.attendees.join(", ")}` : "";
        return `- ${apptStart} - ${apptEnd} ${item.title}${attendeesStr}`;
      }
      case "project": {
        return `## project: ${item.title}${item.target_date ? ` (target: ${item.target_date})` : ""}`;
      }
    }
  }
  onClose() {
    const { contentEl } = this;
    contentEl.empty();
  }
};

// src/modals/LinkItemModal.ts
var import_obsidian3 = require("obsidian");

// src/ElysiumItemReader.ts
function getFs2() {
  var _a;
  return (_a = window.require) == null ? void 0 : _a.call(window, "fs");
}
function getPath() {
  var _a;
  return (_a = window.require) == null ? void 0 : _a.call(window, "path");
}
var ElysiumItemReader = class {
  /**
   * Read all items from .ot files in the Elysium folder
   */
  readAllItems(elysiumFolderPath) {
    if (!elysiumFolderPath) {
      return [];
    }
    const fs = getFs2();
    const pathModule = getPath();
    if (!fs || !pathModule) {
      return [];
    }
    const items = [];
    try {
      const normalizedPath = elysiumFolderPath.replace(/\/$/, "");
      if (!fs.existsSync(normalizedPath)) {
        console.debug("[OpenTime] Elysium folder does not exist:", normalizedPath);
        return [];
      }
      const files = fs.readdirSync(normalizedPath);
      const otFiles = files.filter((f) => f.endsWith(".ot"));
      for (const filename of otFiles) {
        const filepath = pathModule.join(normalizedPath, filename);
        try {
          const content = fs.readFileSync(filepath, "utf8");
          const doc = load(content);
          if (doc && doc.items) {
            for (const item of doc.items) {
              items.push({
                id: item.id,
                title: item.title,
                type: item.type,
                filename,
                filepath
              });
            }
          }
        } catch (parseError) {
          console.warn(`[OpenTime] Failed to parse ${filename}:`, parseError);
        }
      }
      return items;
    } catch (error) {
      console.error("[OpenTime] Failed to read Elysium folder:", error);
      return [];
    }
  }
  /**
   * Read a specific .ot file and return its document
   */
  readDocument(filepath) {
    const fs = getFs2();
    if (!fs)
      return null;
    try {
      if (!fs.existsSync(filepath)) {
        return null;
      }
      const content = fs.readFileSync(filepath, "utf8");
      return load(content);
    } catch (error) {
      console.error("[OpenTime] Failed to read document:", error);
      return null;
    }
  }
  /**
   * Update an item in its .ot file to add Obsidian linking info
   */
  linkItemToObsidian(filepath, itemId, obsidianInfo) {
    const fs = getFs2();
    if (!fs)
      return false;
    try {
      const content = fs.readFileSync(filepath, "utf8");
      const doc = load(content);
      if (!doc || !doc.items) {
        return false;
      }
      let found = false;
      for (const item of doc.items) {
        if (item.id === itemId) {
          item.x_elysium = {
            obsidian_enabled: true,
            obsidian_vault_name: obsidianInfo.vault_name,
            obsidian_folder_path: obsidianInfo.folder_path,
            obsidian_source_file: obsidianInfo.source_file,
            obsidian_behavior: obsidianInfo.behavior
          };
          found = true;
          break;
        }
      }
      if (!found) {
        return false;
      }
      const yamlContent = this.serializeDocument(doc);
      fs.writeFileSync(filepath, yamlContent, "utf8");
      return true;
    } catch (error) {
      console.error("[OpenTime] Failed to link item:", error);
      return false;
    }
  }
  /**
   * Serialize document back to YAML with proper formatting
   */
  serializeDocument(doc) {
    const lines = [];
    lines.push("# opentime file");
    lines.push("# modified by obsidian opentime export plugin");
    lines.push("");
    lines.push(`opentime_version: "${doc.opentime_version || "0.2"}"`);
    if (doc.default_timezone) {
      lines.push(`default_timezone: "${doc.default_timezone}"`);
    }
    if (doc.generated_by) {
      lines.push(`generated_by: "${doc.generated_by}"`);
    }
    lines.push(`created_at: "${doc.created_at || new Date().toISOString()}"`);
    lines.push("");
    lines.push("items:");
    for (const item of doc.items) {
      lines.push(...this.serializeItem(item));
    }
    return lines.join("\n");
  }
  /**
   * Serialize a single item to YAML
   */
  serializeItem(item) {
    const lines = [];
    const indent = "    ";
    lines.push(`  - type: ${item.type}`);
    lines.push(`${indent}id: ${this.quote(item.id)}`);
    lines.push(`${indent}title: ${this.quote(item.title)}`);
    switch (item.type) {
      case "goal":
        lines.push(`${indent}kind: goal`);
        if (item.target_date)
          lines.push(`${indent}target_date: ${this.quote(item.target_date)}`);
        if (item.progress !== void 0)
          lines.push(`${indent}progress: ${item.progress}`);
        if (item.project_id)
          lines.push(`${indent}project_id: ${this.quote(item.project_id)}`);
        break;
      case "task":
        lines.push(`${indent}status: ${item.status}`);
        if (item.due)
          lines.push(`${indent}due: ${this.quote(item.due)}`);
        if (item.scheduled_start)
          lines.push(`${indent}scheduled_start: ${this.quote(item.scheduled_start)}`);
        if (item.estimate_minutes)
          lines.push(`${indent}estimate_minutes: ${item.estimate_minutes}`);
        if (item.priority !== void 0)
          lines.push(`${indent}priority: ${item.priority}`);
        if (item.goal_id)
          lines.push(`${indent}goal_id: ${this.quote(item.goal_id)}`);
        if (item.project_id)
          lines.push(`${indent}project_id: ${this.quote(item.project_id)}`);
        break;
      case "habit":
        if (item.pattern) {
          lines.push(`${indent}pattern:`);
          if (item.pattern.freq)
            lines.push(`${indent}  freq: ${item.pattern.freq}`);
        }
        if (item.goal_id)
          lines.push(`${indent}goal_id: ${this.quote(item.goal_id)}`);
        break;
      case "reminder":
        lines.push(`${indent}time: ${this.quote(item.time)}`);
        if (item.repeat)
          lines.push(`${indent}repeat: ${this.quote(item.repeat)}`);
        break;
      case "event":
        lines.push(`${indent}start: ${this.quote(item.start)}`);
        lines.push(`${indent}end: ${this.quote(item.end)}`);
        if (item.location)
          lines.push(`${indent}location: ${this.quote(item.location)}`);
        if (item.goal_id)
          lines.push(`${indent}goal_id: ${this.quote(item.goal_id)}`);
        break;
      case "appointment":
        lines.push(`${indent}start: ${this.quote(item.start)}`);
        lines.push(`${indent}end: ${this.quote(item.end)}`);
        if (item.attendees)
          lines.push(`${indent}attendees: [${item.attendees.map((a) => this.quote(a)).join(", ")}]`);
        if (item.location)
          lines.push(`${indent}location: ${this.quote(item.location)}`);
        break;
      case "project":
        lines.push(`${indent}kind: project`);
        if (item.target_date)
          lines.push(`${indent}target_date: ${this.quote(item.target_date)}`);
        if (item.progress !== void 0)
          lines.push(`${indent}progress: ${item.progress}`);
        break;
    }
    if (item.tags && item.tags.length > 0) {
      lines.push(`${indent}tags: [${item.tags.map((t) => this.quote(t)).join(", ")}]`);
    }
    if (item.notes) {
      if (item.notes.includes("\n")) {
        lines.push(`${indent}notes: |`);
        for (const line of item.notes.split("\n")) {
          lines.push(`${indent}  ${line}`);
        }
      } else {
        lines.push(`${indent}notes: ${this.quote(item.notes)}`);
      }
    }
    if (item.x_obsidian) {
      lines.push(`${indent}x_obsidian:`);
      lines.push(`${indent}  source_file: ${this.quote(item.x_obsidian.source_file)}`);
      if (item.x_obsidian.folder_path) {
        lines.push(`${indent}  folder_path: ${this.quote(item.x_obsidian.folder_path)}`);
      }
    }
    if (item.x_elysium) {
      lines.push(`${indent}x_elysium:`);
      lines.push(`${indent}  obsidian_enabled: ${item.x_elysium.obsidian_enabled}`);
      if (item.x_elysium.obsidian_vault_name) {
        lines.push(`${indent}  obsidian_vault_name: ${this.quote(item.x_elysium.obsidian_vault_name)}`);
      }
      if (item.x_elysium.obsidian_folder_path) {
        lines.push(`${indent}  obsidian_folder_path: ${this.quote(item.x_elysium.obsidian_folder_path)}`);
      }
      if (item.x_elysium.obsidian_source_file) {
        lines.push(`${indent}  obsidian_source_file: ${this.quote(item.x_elysium.obsidian_source_file)}`);
      }
      if (item.x_elysium.obsidian_behavior) {
        lines.push(`${indent}  obsidian_behavior: ${item.x_elysium.obsidian_behavior}`);
      }
    }
    lines.push("");
    return lines;
  }
  quote(value) {
    const needsQuotes = /[:#[\]{}|>&*?!,'"%@`]|^\s|\s$|^-\s|^$/;
    if (needsQuotes.test(value) || value.includes("\n")) {
      return `"${value.replace(/"/g, '\\"').replace(/\n/g, "\\n")}"`;
    }
    return value;
  }
};

// src/modals/LinkItemModal.ts
var LinkItemModal = class extends import_obsidian3.SuggestModal {
  constructor(app, settings, currentFile) {
    super(app);
    this.items = [];
    this.settings = settings;
    this.currentFile = currentFile;
    this.itemReader = new ElysiumItemReader();
    this.vaultName = this.app.vault.getName();
    const adapter = this.app.vault.adapter;
    this.vaultPath = adapter instanceof import_obsidian3.FileSystemAdapter ? adapter.getBasePath() : "";
    this.setPlaceholder("Search for an item to link...");
    this.setInstructions([
      { command: "\u2191\u2193", purpose: "to navigate" },
      { command: "\u21B5", purpose: "to select" },
      { command: "esc", purpose: "to dismiss" }
    ]);
  }
  onOpen() {
    void super.onOpen();
    if (!this.settings.elysiumFolderPath) {
      new import_obsidian3.Notice("Export folder not configured. Please set it in plugin settings.");
      this.close();
      return;
    }
    this.items = this.itemReader.readAllItems(this.settings.elysiumFolderPath);
    if (this.items.length === 0) {
      new import_obsidian3.Notice("No items found in export folder");
      this.close();
      return;
    }
    this.inputEl.dispatchEvent(new Event("input"));
  }
  getSuggestions(query) {
    const lowerQuery = query.toLowerCase();
    return this.items.filter(
      (item) => item.title.toLowerCase().includes(lowerQuery) || item.type.toLowerCase().includes(lowerQuery) || item.id.toLowerCase().includes(lowerQuery)
    );
  }
  renderSuggestion(item, el) {
    const container = el.createDiv({ cls: "elysium-link-suggestion" });
    const badge = container.createSpan({ cls: "elysium-type-badge" });
    badge.setText(this.getTypeEmoji(item.type) + " " + item.type);
    const title = container.createDiv({ cls: "elysium-item-title" });
    title.setText(item.title);
    const id = container.createDiv({ cls: "elysium-item-id" });
    id.setText(item.id);
  }
  onChooseSuggestion(item) {
    if (!this.currentFile) {
      new import_obsidian3.Notice("No active file to link");
      return;
    }
    const success = this.itemReader.linkItemToObsidian(
      item.filepath,
      item.id,
      {
        source_file: this.currentFile.path,
        folder_path: this.vaultPath,
        vault_name: this.vaultName,
        behavior: "alongside"
      }
    );
    if (success) {
      new import_obsidian3.Notice(`Linked "${item.title}" to ${this.currentFile.basename}`);
    } else {
      new import_obsidian3.Notice("Failed to link item");
    }
  }
  getTypeEmoji(type2) {
    switch (type2) {
      case "goal":
        return "\u{1F3AF}";
      case "task":
        return "\u2705";
      case "habit":
        return "\u{1F504}";
      case "reminder":
        return "\u23F0";
      case "event":
        return "\u{1F4C5}";
      case "appointment":
        return "\u{1F465}";
      case "project":
        return "\u{1F4C1}";
      default:
        return "\u{1F4DD}";
    }
  }
};

// src/parsers/TasksParser.ts
var EMOJI_PATTERNS = {
  due: /📅\s*(\d{4}-\d{2}-\d{2})/,
  scheduled: /⏳\s*(\d{4}-\d{2}-\d{2})/,
  start: /🛫\s*(\d{4}-\d{2}-\d{2})/,
  done: /✅\s*(\d{4}-\d{2}-\d{2})/,
  created: /➕\s*(\d{4}-\d{2}-\d{2})/,
  recurring: /🔁\s*([^\s]+)/,
  priority: {
    high: /[⏫🔺]/u,
    medium: /[🔼]/u,
    low: /[🔽⏬]/u
  }
};
var TASK_PATTERN = /^(\s*)-\s*\[([ xX])\]\s*(.+)$/;
var TasksParser = class {
  constructor(idPrefix = "obs") {
    this.idPrefix = idPrefix;
  }
  /**
   * Parse a markdown file for tasks
   */
  parseFile(content, file) {
    const lines = content.split("\n");
    const tasks = [];
    lines.forEach((line, index) => {
      const parsed = this.parseLine(line, index + 1);
      if (parsed) {
        tasks.push(this.toOpenTimeTask(parsed, file));
      }
    });
    return tasks;
  }
  /**
   * Parse a single line for task content
   */
  parseLine(line, lineNumber) {
    const match = line.match(TASK_PATTERN);
    if (!match)
      return null;
    const [, , checkbox, content] = match;
    const completed = checkbox.toLowerCase() === "x";
    const dueMatch = content.match(EMOJI_PATTERNS.due);
    const scheduledMatch = content.match(EMOJI_PATTERNS.scheduled);
    const startMatch = content.match(EMOJI_PATTERNS.start);
    const doneMatch = content.match(EMOJI_PATTERNS.done);
    let priority;
    if (EMOJI_PATTERNS.priority.high.test(content)) {
      priority = 9;
    } else if (EMOJI_PATTERNS.priority.medium.test(content)) {
      priority = 5;
    } else if (EMOJI_PATTERNS.priority.low.test(content)) {
      priority = 1;
    }
    const tagPattern = /#([a-zA-Z0-9_-]+)/g;
    const tags = [];
    let tagMatch;
    while ((tagMatch = tagPattern.exec(content)) !== null) {
      tags.push(tagMatch[1]);
    }
    const title = content.replace(EMOJI_PATTERNS.due, "").replace(EMOJI_PATTERNS.scheduled, "").replace(EMOJI_PATTERNS.start, "").replace(EMOJI_PATTERNS.done, "").replace(EMOJI_PATTERNS.created, "").replace(EMOJI_PATTERNS.recurring, "").replace(EMOJI_PATTERNS.priority.high, "").replace(EMOJI_PATTERNS.priority.medium, "").replace(EMOJI_PATTERNS.priority.low, "").replace(/#[a-zA-Z0-9_-]+/g, "").trim();
    return {
      title,
      completed,
      dueDate: dueMatch == null ? void 0 : dueMatch[1],
      scheduledDate: scheduledMatch == null ? void 0 : scheduledMatch[1],
      startDate: startMatch == null ? void 0 : startMatch[1],
      doneDate: doneMatch == null ? void 0 : doneMatch[1],
      priority,
      tags: tags.length > 0 ? tags : void 0,
      lineNumber,
      originalText: line
    };
  }
  /**
   * Convert parsed task to OpenTime format
   */
  toOpenTimeTask(parsed, file) {
    return {
      type: "task",
      id: generateId(this.idPrefix + "_task", parsed.title),
      title: parsed.title,
      status: parsed.completed ? "done" : "todo",
      due: parsed.dueDate,
      scheduled_start: parsed.scheduledDate ? `${parsed.scheduledDate}T09:00:00` : void 0,
      priority: parsed.priority,
      tags: parsed.tags,
      x_obsidian: {
        source_file: file.path,
        line_number: parsed.lineNumber,
        original_text: parsed.originalText
      }
    };
  }
};

// src/parsers/DayPlannerParser.ts
var TIME_RANGE_PATTERN = /^(\s*)-?\s*(\d{1,2}:\d{2})\s*-\s*(\d{1,2}:\d{2})\s+(.+)$/;
var SINGLE_TIME_PATTERN = /^(\s*)-?\s*(\d{1,2}:\d{2})\s+(.+)$/;
var DayPlannerParser = class {
  constructor(idPrefix = "obs", defaultDuration = 30, defaultTimezone = "UTC") {
    this.idPrefix = idPrefix;
    this.defaultDuration = defaultDuration;
    this.defaultTimezone = defaultTimezone;
  }
  /**
   * Parse a markdown file for time blocks
   * @param content File content
   * @param file The file being parsed
   * @param date The date for the events (from frontmatter or filename)
   */
  parseFile(content, file, date) {
    const lines = content.split("\n");
    const events = [];
    const fileDate = date || this.extractDateFromFilename(file.basename);
    if (!fileDate) {
      return events;
    }
    lines.forEach((line, index) => {
      const parsed = this.parseLine(line, index + 1);
      if (parsed) {
        events.push(this.toOpenTimeEvent(parsed, file, fileDate));
      }
    });
    return events;
  }
  /**
   * Extract date from filename like "2025-01-15" or "2025-01-15 Daily Note"
   */
  extractDateFromFilename(filename) {
    const match = filename.match(/(\d{4}-\d{2}-\d{2})/);
    return match == null ? void 0 : match[1];
  }
  /**
   * Parse a single line for time block content
   */
  parseLine(line, lineNumber) {
    const rangeMatch = line.match(TIME_RANGE_PATTERN);
    if (rangeMatch) {
      const [, , startTime, endTime, title] = rangeMatch;
      return {
        title: title.trim(),
        startTime: this.normalizeTime(startTime),
        endTime: this.normalizeTime(endTime),
        lineNumber,
        originalText: line
      };
    }
    const singleMatch = line.match(SINGLE_TIME_PATTERN);
    if (singleMatch) {
      const [, , startTime, title] = singleMatch;
      return {
        title: title.trim(),
        startTime: this.normalizeTime(startTime),
        lineNumber,
        originalText: line
      };
    }
    return null;
  }
  /**
   * Normalize time to HH:MM format
   */
  normalizeTime(time) {
    const [hours, minutes] = time.split(":");
    return `${hours.padStart(2, "0")}:${minutes}`;
  }
  /**
   * Add minutes to a time string
   */
  addMinutes(time, minutes) {
    const [h, m] = time.split(":").map(Number);
    const totalMinutes = h * 60 + m + minutes;
    const newHours = Math.floor(totalMinutes / 60) % 24;
    const newMinutes = totalMinutes % 60;
    return `${String(newHours).padStart(2, "0")}:${String(newMinutes).padStart(2, "0")}`;
  }
  /**
   * Convert parsed time block to OpenTime event
   */
  toOpenTimeEvent(parsed, file, date) {
    const endTime = parsed.endTime || this.addMinutes(parsed.startTime, this.defaultDuration);
    return {
      type: "event",
      id: generateId(this.idPrefix + "_ev", `${date}_${parsed.startTime}`),
      title: parsed.title,
      start: `${date}T${parsed.startTime}:00`,
      end: `${date}T${endTime}:00`,
      timezone: this.defaultTimezone,
      x_obsidian: {
        source_file: file.path,
        line_number: parsed.lineNumber,
        original_text: parsed.originalText
      }
    };
  }
};

// src/parsers/FrontmatterParser.ts
var import_obsidian4 = require("obsidian");
var FrontmatterParser = class {
  constructor(idPrefix = "obs", defaultTimezone = "UTC") {
    this.idPrefix = idPrefix;
    this.defaultTimezone = defaultTimezone;
  }
  /**
   * Parse frontmatter from file content
   */
  parseFile(content, file) {
    const frontmatter = this.extractFrontmatter(content);
    if (!frontmatter)
      return null;
    const type2 = this.determineType(frontmatter);
    if (!type2)
      return null;
    const title = frontmatter.title || file.basename;
    switch (type2) {
      case "task":
        return this.toTask(frontmatter, title, file);
      case "event":
        return this.toEvent(frontmatter, title, file);
      case "goal":
        return this.toGoal(frontmatter, title, file);
      case "habit":
        return this.toHabit(frontmatter, title, file);
      default:
        return null;
    }
  }
  /**
   * Extract and parse YAML frontmatter
   */
  extractFrontmatter(content) {
    const match = content.match(/^---\n([\s\S]*?)\n---/);
    if (!match)
      return null;
    try {
      return (0, import_obsidian4.parseYaml)(match[1]);
    } catch (e) {
      return null;
    }
  }
  /**
   * Determine item type from frontmatter fields
   */
  determineType(fm) {
    if (fm.type) {
      return fm.type.toLowerCase();
    }
    if (fm.due || fm.status) {
      return "task";
    }
    if (fm.start && fm.end) {
      return "event";
    }
    if (fm.date && (fm.startTime || fm.endTime)) {
      return "event";
    }
    if (fm.target_date || fm.progress !== void 0) {
      return "goal";
    }
    if (fm.frequency) {
      return "habit";
    }
    return null;
  }
  /**
   * Convert to OpenTime task
   */
  toTask(fm, title, file) {
    var _a;
    const statusMap = {
      "todo": "todo",
      "in_progress": "in_progress",
      "in-progress": "in_progress",
      "inprogress": "in_progress",
      "done": "done",
      "complete": "done",
      "completed": "done",
      "cancelled": "cancelled",
      "canceled": "cancelled"
    };
    return {
      type: "task",
      id: generateId(this.idPrefix + "_task", title),
      title,
      status: statusMap[((_a = fm.status) == null ? void 0 : _a.toLowerCase()) || ""] || "todo",
      due: fm.due,
      scheduled_start: fm.scheduled,
      priority: fm.priority,
      tags: fm.tags,
      notes: fm.notes,
      x_obsidian: {
        source_file: file.path
      }
    };
  }
  /**
   * Convert to OpenTime event
   */
  toEvent(fm, title, file) {
    let start;
    let end;
    if (fm.start && fm.end) {
      start = fm.start;
      end = fm.end;
    } else if (fm.date) {
      const startTime = fm.startTime || "09:00";
      const endTime = fm.endTime || "10:00";
      start = `${fm.date}T${startTime}:00`;
      end = `${fm.date}T${endTime}:00`;
    } else {
      start = new Date().toISOString();
      end = new Date().toISOString();
    }
    return {
      type: "event",
      id: generateId(this.idPrefix + "_ev", title),
      title,
      start,
      end,
      all_day: fm.allDay,
      location: fm.location,
      timezone: this.defaultTimezone,
      tags: fm.tags,
      notes: fm.notes,
      x_obsidian: {
        source_file: file.path
      }
    };
  }
  /**
   * Convert to OpenTime goal
   */
  toGoal(fm, title, file) {
    return {
      type: "goal",
      kind: "goal",
      id: generateId(this.idPrefix + "_goal", title),
      title,
      target_date: fm.target_date,
      progress: fm.progress,
      tags: fm.tags,
      notes: fm.notes,
      x_obsidian: {
        source_file: file.path
      }
    };
  }
  /**
   * Convert to OpenTime habit
   */
  toHabit(fm, title, file) {
    const freqMap = {
      "daily": "daily",
      "weekly": "weekly",
      "custom": "custom"
    };
    return {
      type: "habit",
      id: generateId(this.idPrefix + "_habit", title),
      title,
      pattern: fm.frequency ? { freq: freqMap[fm.frequency.toLowerCase()] || "daily" } : void 0,
      tags: fm.tags,
      notes: fm.notes,
      x_obsidian: {
        source_file: file.path
      }
    };
  }
};

// src/SettingsTab.ts
var import_obsidian5 = require("obsidian");
var DEFAULT_SETTINGS = {
  elysiumFolderPath: "",
  enableTasksParser: true,
  enableDayPlannerParser: true,
  enableFrontmatterParser: true,
  includeFolders: "",
  excludeFolders: "",
  defaultTimezone: Intl.DateTimeFormat().resolvedOptions().timeZone || "UTC",
  defaultEventDuration: 30,
  autoExport: false,
  insertMarkdownByDefault: false,
  idPrefix: "obs"
};
var OpenTimeExportSettingTab = class extends import_obsidian5.PluginSettingTab {
  constructor(app, plugin) {
    super(app, plugin);
    this.folderPathInput = null;
    this.elysiumPrefs = null;
    this.elysiumInstalled = false;
    this.plugin = plugin;
  }
  display() {
    const { containerEl } = this;
    containerEl.empty();
    void this.loadPreferencesAndBuildUI(containerEl);
  }
  async loadPreferencesAndBuildUI(containerEl) {
    this.elysiumInstalled = await isElysiumInstalled();
    this.elysiumPrefs = await readElysiumPreferences();
    new import_obsidian5.Setting(containerEl).setName("Opentime export").setHeading();
    new import_obsidian5.Setting(containerEl).setName("Integration").setHeading();
    this.renderElysiumStatus(containerEl);
    const folderSetting = new import_obsidian5.Setting(containerEl).setName("Export folder").setDesc("Folder where .ot files are saved");
    folderSetting.addText((text) => {
      text.setPlaceholder("Click browse to select folder").setValue(this.plugin.settings.elysiumFolderPath);
      text.inputEl.addClass("opentime-wide-input");
      this.folderPathInput = text;
      text.onChange(async (value) => {
        this.plugin.settings.elysiumFolderPath = value;
        await this.plugin.saveSettings();
      });
    });
    folderSetting.addButton((button) => {
      button.setButtonText("browse...").onClick(() => {
        void (async () => {
          var _a;
          const folder = await this.selectFolder();
          if (folder) {
            this.plugin.settings.elysiumFolderPath = folder;
            (_a = this.folderPathInput) == null ? void 0 : _a.setValue(folder);
            await this.plugin.saveSettings();
          }
        })();
      });
    });
    if (this.elysiumPrefs) {
      new import_obsidian5.Setting(containerEl).setName("Export mode").setDesc("Synced from app preferences").addText((text) => {
        text.setValue(getExportModeDescription(this.elysiumPrefs)).setDisabled(true);
        text.inputEl.addClass("opentime-wide-input");
      });
    }
    new import_obsidian5.Setting(containerEl).setName("Data sources").setHeading();
    new import_obsidian5.Setting(containerEl).setName("Parse tasks plugin format").setDesc("Extract tasks with emoji dates (\u{1F4C5} due, \u23F3 scheduled, \u{1F6EB} start, \u2705 done)").addToggle((toggle) => toggle.setValue(this.plugin.settings.enableTasksParser).onChange(async (value) => {
      this.plugin.settings.enableTasksParser = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian5.Setting(containerEl).setName("Parse day planner format").setDesc('Extract time blocks (e.g., "09:00 - 10:00 meeting")').addToggle((toggle) => toggle.setValue(this.plugin.settings.enableDayPlannerParser).onChange(async (value) => {
      this.plugin.settings.enableDayPlannerParser = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian5.Setting(containerEl).setName("Parse YAML frontmatter").setDesc("Extract items from frontmatter with date/type fields").addToggle((toggle) => toggle.setValue(this.plugin.settings.enableFrontmatterParser).onChange(async (value) => {
      this.plugin.settings.enableFrontmatterParser = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian5.Setting(containerEl).setName("Scope").setHeading();
    new import_obsidian5.Setting(containerEl).setName("Include folders").setDesc("Only scan these folders (comma-separated, leave empty for all)").addText((text) => text.setPlaceholder("daily, projects").setValue(this.plugin.settings.includeFolders).onChange(async (value) => {
      this.plugin.settings.includeFolders = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian5.Setting(containerEl).setName("Exclude folders").setDesc("Skip these folders (comma-separated)").addText((text) => text.setPlaceholder("templates, archive").setValue(this.plugin.settings.excludeFolders).onChange(async (value) => {
      this.plugin.settings.excludeFolders = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian5.Setting(containerEl).setName("Behavior").setHeading();
    new import_obsidian5.Setting(containerEl).setName("Default timezone").setDesc("IANA timezone for events without explicit timezone").addText((text) => text.setPlaceholder("America/Los_Angeles").setValue(this.plugin.settings.defaultTimezone).onChange(async (value) => {
      this.plugin.settings.defaultTimezone = value || "UTC";
      await this.plugin.saveSettings();
    }));
    new import_obsidian5.Setting(containerEl).setName("Default event duration").setDesc("Duration in minutes for events without end time").addSlider((slider) => slider.setLimits(15, 120, 15).setValue(this.plugin.settings.defaultEventDuration).setDynamicTooltip().onChange(async (value) => {
      this.plugin.settings.defaultEventDuration = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian5.Setting(containerEl).setName("Auto-export on save").setDesc("Automatically update the .ot file when you save a note").addToggle((toggle) => toggle.setValue(this.plugin.settings.autoExport).onChange(async (value) => {
      this.plugin.settings.autoExport = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian5.Setting(containerEl).setName("Insert markdown when creating items").setDesc("Also insert markdown into the current note when creating items").addToggle((toggle) => toggle.setValue(this.plugin.settings.insertMarkdownByDefault).onChange(async (value) => {
      this.plugin.settings.insertMarkdownByDefault = value;
      await this.plugin.saveSettings();
    }));
    new import_obsidian5.Setting(containerEl).setName("Advanced").setHeading();
    new import_obsidian5.Setting(containerEl).setName("ID prefix").setDesc('Prefix for generated item IDs (e.g., "obs" creates "obs_task_...")').addText((text) => text.setPlaceholder("obs").setValue(this.plugin.settings.idPrefix).onChange(async (value) => {
      this.plugin.settings.idPrefix = value || "obs";
      await this.plugin.saveSettings();
    }));
  }
  /**
   * Render Elysium detection status
   */
  renderElysiumStatus(container) {
    const statusEl = container.createDiv({ cls: "setting-item" });
    const infoEl = statusEl.createDiv({ cls: "setting-item-info" });
    const descEl = infoEl.createDiv({ cls: "setting-item-description" });
    if (this.elysiumInstalled) {
      descEl.createSpan({
        text: "\u2713 Elysium detected - export mode synced from app preferences",
        cls: "opentime-status-ok"
      });
    } else {
      descEl.createSpan({
        text: "\u26A0 Elysium not detected - using default settings (single file mode)",
        cls: "opentime-status-warning"
      });
    }
  }
  /**
   * Open native folder picker dialog
   */
  async selectFolder() {
    var _a, _b, _c, _d;
    try {
      let dialog = null;
      const electronRemote = (_a = window.require) == null ? void 0 : _a.call(window, "@electron/remote");
      if (electronRemote == null ? void 0 : electronRemote.dialog) {
        dialog = electronRemote.dialog;
      }
      if (!dialog) {
        const electron = (_b = window.require) == null ? void 0 : _b.call(window, "electron");
        if ((_c = electron == null ? void 0 : electron.remote) == null ? void 0 : _c.dialog) {
          dialog = electron.remote.dialog;
        } else if (electron == null ? void 0 : electron.dialog) {
          dialog = electron.dialog;
        }
      }
      if (!dialog) {
        new import_obsidian5.Notice("Folder picker not available. Please enter the path manually.");
        return null;
      }
      const os = (_d = window.require) == null ? void 0 : _d.call(window, "os");
      const defaultPath = this.plugin.settings.elysiumFolderPath || ((os == null ? void 0 : os.homedir) ? `${os.homedir()}/Documents` : "");
      const result = await dialog.showOpenDialog({
        title: "Select export folder",
        properties: ["openDirectory", "createDirectory"],
        defaultPath
      });
      if (!result.canceled && result.filePaths && result.filePaths.length > 0) {
        return result.filePaths[0];
      }
    } catch (error) {
      console.error("[OpenTime] Failed to open folder picker:", error);
      new import_obsidian5.Notice("Failed to open folder picker. Please enter the path manually.");
    }
    return null;
  }
};

// main.ts
var OpenTimeExportPlugin = class extends import_obsidian6.Plugin {
  async onload() {
    await this.loadSettings();
    this.initializeParsers();
    this.elysiumExporter = new ElysiumExporter(this.manifest.version);
    const elysiumInstalled = await isElysiumInstalled();
    if (!elysiumInstalled) {
      console.debug("[OpenTime] Elysium not detected - using default settings");
    }
    this.addRibbonIcon("calendar-clock", "Export to opentime", async () => {
      await this.exportAll();
    });
    this.addCommand({
      id: "export-all",
      name: "Export all items",
      callback: async () => {
        await this.exportAll();
      }
    });
    this.addCommand({
      id: "export-current-file",
      name: "Export current file",
      checkCallback: (checking) => {
        const file = this.app.workspace.getActiveFile();
        if (file) {
          if (!checking) {
            void this.exportFile(file);
          }
          return true;
        }
        return false;
      }
    });
    this.addCommand({
      id: "create-item",
      name: "Create new item",
      callback: () => {
        this.openCreateModal(null);
      }
    });
    this.addCommand({
      id: "create-goal",
      name: "Create new goal",
      callback: () => {
        this.openCreateModal("goal");
      }
    });
    this.addCommand({
      id: "create-task",
      name: "Create new task",
      callback: () => {
        this.openCreateModal("task");
      }
    });
    this.addCommand({
      id: "create-habit",
      name: "Create new habit",
      callback: () => {
        this.openCreateModal("habit");
      }
    });
    this.addCommand({
      id: "create-reminder",
      name: "Create new reminder",
      callback: () => {
        this.openCreateModal("reminder");
      }
    });
    this.addCommand({
      id: "create-event",
      name: "Create new event",
      callback: () => {
        this.openCreateModal("event");
      }
    });
    this.addCommand({
      id: "create-appointment",
      name: "Create new appointment",
      callback: () => {
        this.openCreateModal("appointment");
      }
    });
    this.addCommand({
      id: "create-project",
      name: "Create new project",
      callback: () => {
        this.openCreateModal("project");
      }
    });
    this.addCommand({
      id: "link-to-elysium",
      name: "Link to existing item",
      checkCallback: (checking) => {
        const file = this.app.workspace.getActiveFile();
        if (file) {
          if (!checking) {
            this.openLinkModal();
          }
          return true;
        }
        return false;
      }
    });
    this.registerEvent(
      this.app.workspace.on("file-menu", (menu, file) => {
        if (file.extension === "md") {
          menu.addItem((item) => {
            item.setTitle("Link to existing item").setIcon("link").onClick(() => {
              this.openLinkModal();
            });
          });
        }
      })
    );
    this.registerEvent(
      this.app.workspace.on("editor-menu", (menu) => {
        menu.addItem((item) => {
          item.setTitle("Link to existing item").setIcon("link").onClick(() => {
            this.openLinkModal();
          });
        });
        menu.addItem((item) => {
          item.setTitle("Create new item").setIcon("plus-circle").onClick(() => {
            this.openCreateModal(null);
          });
        });
      })
    );
    this.addSettingTab(new OpenTimeExportSettingTab(this.app, this));
    this.registerEvent(
      this.app.vault.on("modify", (file) => {
        if (this.settings.autoExport && file instanceof import_obsidian6.TFile && file.extension === "md") {
          void this.exportAll();
        }
      })
    );
    console.debug("[OpenTime] Export plugin loaded");
  }
  onunload() {
    console.debug("[OpenTime] Export plugin unloaded");
  }
  async loadSettings() {
    const data = await this.loadData();
    if (data) {
      delete data.exportPath;
      delete data.exportFilename;
      delete data.elysiumFolderEnabled;
      delete data.defaultVaultName;
      delete data.defaultObsidianBehavior;
    }
    this.settings = Object.assign({}, DEFAULT_SETTINGS, data);
  }
  async saveSettings() {
    await this.saveData(this.settings);
    this.initializeParsers();
  }
  /**
   * Initialize parsers with current settings
   */
  initializeParsers() {
    this.tasksParser = new TasksParser(this.settings.idPrefix);
    this.dayPlannerParser = new DayPlannerParser(
      this.settings.idPrefix,
      this.settings.defaultEventDuration,
      this.settings.defaultTimezone
    );
    this.frontmatterParser = new FrontmatterParser(
      this.settings.idPrefix,
      this.settings.defaultTimezone
    );
  }
  /**
   * Export all matching files to Elysium
   */
  async exportAll() {
    if (!this.settings.elysiumFolderPath) {
      new import_obsidian6.Notice("Export folder not configured. Please set it in plugin settings.");
      return;
    }
    const startTime = Date.now();
    const items = [];
    const files = this.app.vault.getMarkdownFiles();
    const filteredFiles = this.filterFiles(files);
    for (const file of filteredFiles) {
      const fileItems = await this.parseFile(file);
      items.push(...fileItems);
    }
    if (items.length === 0) {
      new import_obsidian6.Notice("No calendar items found to export");
      return;
    }
    const success = await this.elysiumExporter.exportItems(
      items,
      this.settings.elysiumFolderPath,
      this.settings.defaultTimezone
    );
    if (success) {
      const elapsed = Date.now() - startTime;
      console.debug(`[OpenTime] Exported ${items.length} items in ${elapsed}ms`);
    }
  }
  /**
   * Export a single file
   */
  async exportFile(file) {
    if (!this.settings.elysiumFolderPath) {
      new import_obsidian6.Notice("Export folder not configured. Please set it in plugin settings.");
      return;
    }
    const items = await this.parseFile(file);
    if (items.length === 0) {
      new import_obsidian6.Notice("No calendar items found in this file");
      return;
    }
    await this.elysiumExporter.exportItems(
      items,
      this.settings.elysiumFolderPath,
      this.settings.defaultTimezone
    );
  }
  /**
   * Filter files by include/exclude folder settings
   */
  filterFiles(files) {
    const includeFolders = this.settings.includeFolders.split(",").map((f) => f.trim()).filter((f) => f.length > 0);
    const excludeFolders = this.settings.excludeFolders.split(",").map((f) => f.trim()).filter((f) => f.length > 0);
    return files.filter((file) => {
      for (const exclude of excludeFolders) {
        if (file.path.startsWith(exclude + "/") || file.path === exclude) {
          return false;
        }
      }
      if (includeFolders.length === 0) {
        return true;
      }
      for (const include of includeFolders) {
        if (file.path.startsWith(include + "/") || file.path === include) {
          return true;
        }
      }
      return false;
    });
  }
  /**
   * Parse a file for OpenTime items
   */
  async parseFile(file) {
    const content = await this.app.vault.read(file);
    const items = [];
    let fileDate;
    const frontmatterMatch = content.match(/^---\n[\s\S]*?date:\s*(\d{4}-\d{2}-\d{2})[\s\S]*?\n---/);
    if (frontmatterMatch) {
      fileDate = frontmatterMatch[1];
    }
    if (this.settings.enableTasksParser) {
      items.push(...this.tasksParser.parseFile(content, file));
    }
    if (this.settings.enableDayPlannerParser) {
      items.push(...this.dayPlannerParser.parseFile(content, file, fileDate));
    }
    if (this.settings.enableFrontmatterParser) {
      const frontmatterItem = this.frontmatterParser.parseFile(content, file);
      if (frontmatterItem) {
        items.push(frontmatterItem);
      }
    }
    return items;
  }
  /**
   * Open the create item modal
   */
  openCreateModal(itemType) {
    let initialText = "";
    const activeView = this.app.workspace.getActiveViewOfType(import_obsidian6.MarkdownView);
    if (activeView && activeView.editor) {
      initialText = activeView.editor.getSelection();
    }
    const modal = new CreateItemModal(
      this.app,
      this.settings,
      this.manifest.version,
      itemType,
      initialText
    );
    modal.open();
  }
  /**
   * Open the link item modal to link current note to an Elysium item
   */
  openLinkModal() {
    const currentFile = this.app.workspace.getActiveFile();
    const modal = new LinkItemModal(
      this.app,
      this.settings,
      currentFile
    );
    modal.open();
  }
};
/*! Bundled license information:

js-yaml/dist/js-yaml.mjs:
  (*! js-yaml 4.1.1 https://github.com/nodeca/js-yaml @license MIT *)
*/
